/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.NodeConfiguration;
import rocks.xmpp.extensions.pubsub.model.NodeMetaData;
import rocks.xmpp.extensions.pubsub.model.NodeType;
import rocks.xmpp.extensions.pubsub.model.PubSub;
import rocks.xmpp.extensions.pubsub.model.PublishOptions;
import rocks.xmpp.extensions.pubsub.model.SubscribeOptions;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;

public final class PubSubNode {
    private final Jid pubSubServiceAddress;
    private final XmppSession xmppSession;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private volatile NodeType type;
    private volatile String nodeId;

    PubSubNode(String nodeId, Jid pubSubServiceAddress, XmppSession xmppSession) {
        this(nodeId, nodeId == null ? NodeType.LEAF : NodeType.COLLECTION, pubSubServiceAddress, xmppSession);
    }

    PubSubNode(String nodeId, NodeType type, Jid pubSubServiceAddress, XmppSession xmppSession) {
        this.nodeId = nodeId;
        this.type = type;
        this.pubSubServiceAddress = pubSubServiceAddress;
        this.xmppSession = xmppSession;
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    public NodeMetaData discoverNodeMetaData() throws XmppException {
        if (this.nodeId == null) {
            throw new IllegalStateException("nodeId must not be null.");
        }
        InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(this.pubSubServiceAddress, this.nodeId);
        Identity identity = null;
        NodeMetaData metaDataForm = null;
        if (infoNode != null) {
            Set identities = infoNode.getIdentities();
            Iterator iterator = identities.iterator();
            if (iterator.hasNext()) {
                identity = (Identity)iterator.next();
            }
            for (DataForm dataForm : infoNode.getExtensions()) {
                String formType = dataForm.getFormType();
                if (!"http://jabber.org/protocol/pubsub#meta-data".equals(formType)) continue;
                metaDataForm = new NodeMetaData(dataForm);
                break;
            }
        }
        this.type = identity != null ? ("collection".equals(identity.getType()) ? NodeType.COLLECTION : NodeType.LEAF) : NodeType.LEAF;
        return metaDataForm;
    }

    public List<Item> discoverItems() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.pubSubServiceAddress, this.nodeId);
        ArrayList<Item> result = new ArrayList<Item>();
        for (final rocks.xmpp.extensions.disco.model.items.Item item : itemNode.getItems()) {
            result.add(new Item(){

                public Object getPayload() {
                    return null;
                }

                public String getId() {
                    return item.getName();
                }

                public String getNode() {
                    return null;
                }

                public String getPublisher() {
                    return null;
                }
            });
        }
        return result;
    }

    public List<Subscription> getSubscriptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withSubscriptions((String)this.nodeId)));
        return ((PubSub)result.getExtension(PubSub.class)).getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withAffiliations((String)this.nodeId)));
        return ((PubSub)result.getExtension(PubSub.class)).getAffiliations();
    }

    public Subscription subscribe() throws XmppException {
        return this.subscribe(null);
    }

    public Subscription subscribe(SubscribeOptions subscribeOptions) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withSubscribe((String)Objects.requireNonNull(this.nodeId, "nodeId must not be null"), (Jid)this.xmppSession.getConnectedResource().asBareJid(), (DataForm)(subscribeOptions != null ? subscribeOptions.getDataForm() : null))));
        return ((PubSub)result.getExtension(PubSub.class)).getSubscription();
    }

    public void unsubscribe() throws XmppException {
        this.unsubscribe(null);
    }

    public void unsubscribe(String subscriptionId) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withUnsubscribe((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), (String)subscriptionId)));
    }

    public SubscribeOptions getSubscriptionOptions(boolean defaultOptions) throws XmppException {
        if (defaultOptions) {
            IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withDefault((String)this.nodeId)));
            return new SubscribeOptions(((PubSub)result.getExtension(PubSub.class)).getDefault().getDataForm());
        }
        return this.getSubscriptionOptions();
    }

    public SubscribeOptions getSubscriptionOptions() throws XmppException {
        return this.getSubscriptionOptions(null);
    }

    public SubscribeOptions getSubscriptionOptions(String subId) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withOptions((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), (String)subId, null)));
        return new SubscribeOptions(((PubSub)result.getExtension(PubSub.class)).getOptions().getDataForm());
    }

    @Deprecated
    public void submitSubscriptionOptions(DataForm dataForm) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withOptions((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), null, (DataForm)dataForm)));
    }

    public void configureSubscription(SubscribeOptions subscribeOptions) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withOptions((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), null, (DataForm)(subscribeOptions != null ? subscribeOptions.getDataForm() : null))));
    }

    @Deprecated
    public SubscribeOptions getDefaultSubscriptionOptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withDefault((String)this.nodeId)));
        return new SubscribeOptions(((PubSub)result.getExtension(PubSub.class)).getDefault().getDataForm());
    }

    public List<Item> getItems() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withItems((String)this.nodeId)));
        return ((PubSub)result.getExtension(PubSub.class)).getItems();
    }

    public List<Item> getItems(String ... ids) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withItems((String)this.nodeId, (String[])ids)));
        return ((PubSub)result.getExtension(PubSub.class)).getItems();
    }

    public List<Item> getItems(int maxItems) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withItems((String)this.nodeId, (int)maxItems)));
        return ((PubSub)result.getExtension(PubSub.class)).getItems();
    }

    public String publish(Object item) throws XmppException {
        return this.publish(null, item);
    }

    public String publish(Object item, PublishOptions publishOptions) throws XmppException {
        return this.publish(null, item, publishOptions);
    }

    public String publish(String id, Object item) throws XmppException {
        return this.publish(id, item, null);
    }

    public String publish(String id, Object item, PublishOptions publishOptions) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withPublish((String)this.nodeId, (String)id, (Object)item, (DataForm)(publishOptions != null ? publishOptions.getDataForm() : null))));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        if (pubSub != null && pubSub.getPublish() != null && pubSub.getPublish().getItem() != null) {
            return pubSub.getPublish().getItem().getId();
        }
        return id;
    }

    private void deleteItem(String id, boolean notify) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withRetract((String)this.nodeId, (String)id, (boolean)notify)));
    }

    public String create() throws XmppException {
        return this.create(null);
    }

    public String create(NodeConfiguration nodeConfiguration) throws XmppException {
        String generatedNodeId;
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withCreate((String)this.nodeId, (DataForm)(nodeConfiguration != null ? nodeConfiguration.getDataForm() : null))));
        if (this.nodeId != null) {
            return this.nodeId;
        }
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        if (pubSub != null && (generatedNodeId = pubSub.getNode()) != null) {
            this.nodeId = generatedNodeId;
        }
        return this.nodeId;
    }

    public NodeConfiguration getNodeConfiguration() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSubOwner.withConfigure((String)this.nodeId)));
        PubSubOwner pubSubOwner = (PubSubOwner)result.getExtension(PubSubOwner.class);
        return new NodeConfiguration(pubSubOwner.getConfigurationForm());
    }

    @Deprecated
    public void submitNodeConfiguration(DataForm dataForm) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withConfigure((String)this.nodeId, (DataForm)dataForm)));
    }

    public void configureNode(NodeConfiguration nodeConfiguration) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withConfigure((String)this.nodeId, (DataForm)nodeConfiguration.getDataForm())));
    }

    public void delete() throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withDelete((String)this.nodeId)));
    }

    public void delete(URI uri) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withDelete((String)this.nodeId, (URI)uri)));
    }

    public void purge() throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withPurge((String)this.nodeId)));
    }

    public List<PubSubNode> discoverNodes() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.pubSubServiceAddress, this.nodeId);
        ArrayList<PubSubNode> nodes = new ArrayList<PubSubNode>();
        for (rocks.xmpp.extensions.disco.model.items.Item item : itemNode.getItems()) {
            nodes.add(new PubSubNode(item.getNode(), this.pubSubServiceAddress, this.xmppSession));
        }
        return nodes;
    }

    @Deprecated
    public List<PubSubNode> getNodes() throws XmppException {
        return this.discoverNodes();
    }

    public String getId() {
        return this.nodeId;
    }

    public NodeType getType() {
        return this.type;
    }

    public String toString() {
        return this.nodeId;
    }
}

