/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.pubsub.PubSubNode;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.NodeType;
import rocks.xmpp.extensions.pubsub.model.PubSub;
import rocks.xmpp.extensions.pubsub.model.PubSubFeature;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;

public final class PubSubService {
    private static final Logger logger = Logger.getLogger(PubSubService.class.getName());
    private final Jid service;
    private final String name;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final XmppSession xmppSession;

    PubSubService(Jid service, String name, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager) {
        this.service = service;
        this.name = name;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.xmppSession = xmppSession;
    }

    @Deprecated
    public Collection<PubSubFeature> getFeatures() throws XmppException {
        return this.discoverFeatures();
    }

    public Collection<PubSubFeature> discoverFeatures() throws XmppException {
        InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(this.service);
        return this.getFeatures(infoNode);
    }

    Collection<PubSubFeature> getFeatures(InfoNode infoNode) {
        EnumSet<PubSubFeature> features = EnumSet.noneOf(PubSubFeature.class);
        for (Feature feature : infoNode.getFeatures()) {
            if (!feature.getVar().startsWith("http://jabber.org/protocol/pubsub#")) continue;
            String f = feature.getVar().substring(feature.getVar().indexOf("#") + 1);
            try {
                PubSubFeature pubSubFeature = PubSubFeature.valueOf((String)f.toUpperCase().replace("-", "_"));
                if (pubSubFeature == null) continue;
                features.add(pubSubFeature);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Server advertised unknown pubsub feature: " + f);
            }
        }
        return features;
    }

    @Deprecated
    public List<PubSubNode> getNodes() throws XmppException {
        return this.discoverNodes();
    }

    public List<PubSubNode> discoverNodes() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.service);
        ArrayList<PubSubNode> nodes = new ArrayList<PubSubNode>();
        for (Item item : itemNode.getItems()) {
            nodes.add(new PubSubNode(item.getNode(), this.service, this.xmppSession));
        }
        return nodes;
    }

    @Deprecated
    public PubSubNode getNode(String node) {
        return new PubSubNode(node, NodeType.LEAF, this.service, this.xmppSession);
    }

    public PubSubNode node(String node) {
        return new PubSubNode(node, NodeType.LEAF, this.service, this.xmppSession);
    }

    private List<Subscription> getSubscriptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.service, AbstractIQ.Type.GET, (Object)PubSub.withSubscriptions()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getSubscriptions();
    }

    private List<Affiliation> getAffiliations() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.service, AbstractIQ.Type.GET, (Object)PubSub.withAffiliations()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getAffiliations();
    }

    private DataForm getDefaultSubscriptionOptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.service, AbstractIQ.Type.GET, (Object)PubSub.withDefault()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getDefault().getDataForm();
    }

    private DataForm getDefaultNodeConfiguration() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.service, AbstractIQ.Type.GET, (Object)PubSubOwner.withDefault()));
        PubSubOwner pubSubOwner = (PubSubOwner)result.getExtension(PubSubOwner.class);
        return pubSubOwner.getConfigurationForm();
    }

    public Jid getAddress() {
        return this.service;
    }

    public String toString() {
        return this.service.toString();
    }

    public String getName() {
        return this.name;
    }
}

