/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.reach;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.extensions.reach.ReachabilityEvent;
import rocks.xmpp.extensions.reach.ReachabilityListener;
import rocks.xmpp.extensions.reach.model.Address;
import rocks.xmpp.extensions.reach.model.Reachability;

public final class ReachabilityManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(ReachabilityManager.class.getName());
    private final Set<ReachabilityListener> reachabilityListeners = new CopyOnWriteArraySet<ReachabilityListener>();
    private final Map<Jid, List<Address>> reachabilities = new ConcurrentHashMap<Jid, List<Address>>();
    private final List<Address> addresses = new CopyOnWriteArrayList<Address>();

    private ReachabilityManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:reach:0"});
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ReachabilityManager.this.reachabilityListeners.clear();
                    ReachabilityManager.this.reachabilities.clear();
                    ReachabilityManager.this.addresses.clear();
                }
            }
        });
        this.xmppSession.addInboundPresenceListener(new PresenceListener(){

            public void handlePresence(PresenceEvent e) {
                Presence presence = e.getPresence();
                boolean hasReachability = ReachabilityManager.this.checkStanzaForReachabilityAndNotify((Stanza)presence);
                Jid contact = presence.getFrom().asBareJid();
                if (!hasReachability && ReachabilityManager.this.reachabilities.remove(contact) != null) {
                    ReachabilityManager.this.notifyReachabilityListeners(contact, new ArrayList());
                }
            }
        });
        this.xmppSession.addOutboundPresenceListener(new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handlePresence(PresenceEvent e) {
                Presence presence = e.getPresence();
                if (presence.isAvailable() && presence.getTo() == null) {
                    List list = ReachabilityManager.this.addresses;
                    synchronized (list) {
                        if (!ReachabilityManager.this.addresses.isEmpty()) {
                            presence.getExtensions().add(new Reachability(new ArrayList(ReachabilityManager.this.addresses)));
                        }
                    }
                }
            }
        });
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                ReachabilityManager.this.checkStanzaForReachabilityAndNotify((Stanza)e.getMessage());
            }
        });
        this.xmppSession.addIQHandler(Reachability.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.GET){

            protected IQ processRequest(IQ iq) {
                return iq.createResult((Object)new Reachability(ReachabilityManager.this.addresses));
            }
        });
    }

    public List<Address> getReachabilityAddresses() {
        return this.addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStanzaForReachabilityAndNotify(Stanza stanza) {
        Reachability reachability = (Reachability)stanza.getExtension(Reachability.class);
        if (stanza.getFrom() != null) {
            Jid contact = stanza.getFrom().asBareJid();
            if (reachability != null) {
                Map<Jid, List<Address>> map = this.reachabilities;
                synchronized (map) {
                    List<Address> oldReachabilityAddresses = this.reachabilities.get(contact);
                    if (oldReachabilityAddresses == null || !oldReachabilityAddresses.equals(reachability.getAddresses())) {
                        this.reachabilities.put(contact, reachability.getAddresses());
                        this.notifyReachabilityListeners(contact, reachability.getAddresses());
                    }
                }
            }
        }
        return reachability != null;
    }

    private void notifyReachabilityListeners(Jid from, List<Address> reachabilityAddresses) {
        ReachabilityEvent reachabilityEvent = new ReachabilityEvent((Object)this, from, reachabilityAddresses);
        for (ReachabilityListener reachabilityListener : this.reachabilityListeners) {
            try {
                reachabilityListener.reachabilityChanged(reachabilityEvent);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public void addReachabilityListener(ReachabilityListener reachabilityListener) {
        this.reachabilityListeners.add(reachabilityListener);
    }

    public void removeReachabilityListener(ReachabilityListener reachabilityListener) {
        this.reachabilityListeners.remove(reachabilityListener);
    }

    public List<Address> requestReachabilityAddresses(Jid contact) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(contact, AbstractIQ.Type.GET, (Object)new Reachability()));
        Reachability reachability = (Reachability)result.getExtension(Reachability.class);
        if (reachability != null) {
            return reachability.getAddresses();
        }
        return null;
    }
}

