/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.receipts;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.StanzaFilter;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.receipts.MessageDeliveredEvent;
import rocks.xmpp.extensions.receipts.MessageDeliveredListener;
import rocks.xmpp.extensions.receipts.model.MessageDeliveryReceipts;

public final class MessageDeliveryReceiptsManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(MessageDeliveryReceiptsManager.class.getName());
    final Set<MessageDeliveredListener> messageDeliveredListeners = new CopyOnWriteArraySet<MessageDeliveredListener>();
    private final List<StanzaFilter<Message>> messageFilters = new CopyOnWriteArrayList<StanzaFilter<Message>>();

    private MessageDeliveryReceiptsManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:receipts"});
    }

    protected void initialize() {
        this.messageFilters.add(new StanzaFilter<Message>(){

            public boolean accept(Message message) {
                return message.getType() != AbstractMessage.Type.ERROR;
            }
        });
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    MessageDeliveryReceiptsManager.this.messageDeliveredListeners.clear();
                    MessageDeliveryReceiptsManager.this.messageFilters.clear();
                }
            }
        });
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                MessageDeliveryReceipts.Received received;
                if (!MessageDeliveryReceiptsManager.this.isEnabled()) {
                    return;
                }
                Message message = e.getMessage();
                if (message.getExtension(MessageDeliveryReceipts.Request.class) != null && message.getId() != null) {
                    Message receiptMessage = new Message(message.getFrom(), AbstractMessage.Type.NORMAL, " ");
                    receiptMessage.getExtensions().add(new MessageDeliveryReceipts.Received(message.getId()));
                    MessageDeliveryReceiptsManager.this.xmppSession.send((ClientStreamElement)receiptMessage);
                }
                if ((received = (MessageDeliveryReceipts.Received)message.getExtension(MessageDeliveryReceipts.Received.class)) != null) {
                    DelayedDelivery delayedDelivery = (DelayedDelivery)message.getExtension(DelayedDelivery.class);
                    Date deliveryDate = delayedDelivery != null ? delayedDelivery.getTimeStamp() : new Date();
                    for (MessageDeliveredListener messageDeliveredListener : MessageDeliveryReceiptsManager.this.messageDeliveredListeners) {
                        try {
                            messageDeliveredListener.messageDelivered(new MessageDeliveredEvent((Object)MessageDeliveryReceiptsManager.this, received.getId(), deliveryDate));
                        }
                        catch (Exception ex) {
                            logger.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                }
            }
        });
        this.xmppSession.addOutboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                if (!MessageDeliveryReceiptsManager.this.isEnabled()) {
                    return;
                }
                Message message = e.getMessage();
                for (StanzaFilter messageFilter : MessageDeliveryReceiptsManager.this.messageFilters) {
                    if (messageFilter.accept((Stanza)message)) continue;
                    return;
                }
                if (message.getExtension(MessageDeliveryReceipts.Received.class) == null && message.getId() != null) {
                    message.getExtensions().add(MessageDeliveryReceipts.REQUEST);
                }
            }
        });
    }

    public void addMessageDeliveredListener(MessageDeliveredListener messageDeliveredListener) {
        this.messageDeliveredListeners.add(messageDeliveredListener);
    }

    public void removeMessageDeliveredListener(MessageDeliveredListener messageDeliveredListener) {
        this.messageDeliveredListeners.remove(messageDeliveredListener);
    }

    public void addMessageFilter(StanzaFilter<Message> messageFilter) {
        this.messageFilters.add(messageFilter);
    }

    public void removeMessageFilter(StanzaFilter<Message> messageFilter) {
        this.messageFilters.remove(messageFilter);
    }
}

