/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rosterx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.roster.RosterManager;
import rocks.xmpp.core.roster.model.Contact;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.subscription.PresenceManager;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.rosterx.ContactExchangeEvent;
import rocks.xmpp.extensions.rosterx.ContactExchangeListener;
import rocks.xmpp.extensions.rosterx.model.ContactExchange;

public final class ContactExchangeManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(ContactExchangeManager.class.getName());
    private final Set<ContactExchangeListener> contactExchangeListeners = new CopyOnWriteArraySet<ContactExchangeListener>();
    private final Collection<Jid> trustedEntities = new CopyOnWriteArraySet<Jid>();

    private ContactExchangeManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/rosterx"});
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ContactExchangeManager.this.contactExchangeListeners.clear();
                    ContactExchangeManager.this.trustedEntities.clear();
                }
            }
        });
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                List<ContactExchange.Item> items;
                Message message;
                ContactExchange contactExchange;
                if (ContactExchangeManager.this.isEnabled() && (contactExchange = (ContactExchange)(message = e.getMessage()).getExtension(ContactExchange.class)) != null && !(items = ContactExchangeManager.this.getItemsToProcess(contactExchange.getItems())).isEmpty()) {
                    DelayedDelivery delayedDelivery = (DelayedDelivery)message.getExtension(DelayedDelivery.class);
                    Date date = delayedDelivery != null ? delayedDelivery.getTimeStamp() : new Date();
                    ContactExchangeManager.this.processItems(items, message.getFrom(), message.getBody(), date);
                }
            }
        });
        this.xmppSession.addIQHandler(ContactExchange.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                ContactExchange contactExchange = (ContactExchange)iq.getExtension(ContactExchange.class);
                if (((RosterManager)ContactExchangeManager.this.xmppSession.getManager(RosterManager.class)).getContact(iq.getFrom().asBareJid()) == null) {
                    return iq.createError(Condition.NOT_AUTHORIZED);
                }
                List<ContactExchange.Item> items = ContactExchangeManager.this.getItemsToProcess(contactExchange.getItems());
                if (!items.isEmpty()) {
                    ContactExchangeManager.this.processItems(items, iq.getFrom(), null, new Date());
                }
                return iq.createResult();
            }
        });
    }

    private void processItems(List<ContactExchange.Item> items, Jid sender, String message, Date date) {
        if (this.getTrustedEntities().contains(sender.asBareJid())) {
            for (ContactExchange.Item item : items) {
                try {
                    this.approve(item);
                }
                catch (XmppException e1) {
                    logger.log(Level.SEVERE, "Auto approving roster exchange item failed: " + e1.getMessage(), e1);
                }
            }
        } else {
            for (ContactExchangeListener contactExchangeListener : this.contactExchangeListeners) {
                try {
                    contactExchangeListener.contactExchangeSuggested(new ContactExchangeEvent((Object)this, items, sender, message, date));
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
    }

    List<ContactExchange.Item> getItemsToProcess(List<ContactExchange.Item> items) {
        ArrayList<ContactExchange.Item> newItems = new ArrayList<ContactExchange.Item>();
        for (ContactExchange.Item item : items) {
            ArrayList specifiedGroups;
            Contact contact = ((RosterManager)this.xmppSession.getManager(RosterManager.class)).getContact(item.getJid());
            if (item.getAction() == null || item.getAction() == ContactExchange.Item.Action.ADD) {
                if (contact != null) {
                    specifiedGroups = new ArrayList(item.getGroups());
                    specifiedGroups.removeAll(contact.getGroups());
                    if (specifiedGroups.isEmpty()) continue;
                    newItems.add(new ContactExchange.Item(item.getJid(), item.getName(), specifiedGroups, ContactExchange.Item.Action.ADD));
                    continue;
                }
                newItems.add(item);
                continue;
            }
            if (item.getAction() == ContactExchange.Item.Action.DELETE) {
                if (contact == null) continue;
                specifiedGroups = new ArrayList(item.getGroups());
                specifiedGroups.retainAll(contact.getGroups());
                if (specifiedGroups.isEmpty() && !contact.getGroups().isEmpty()) continue;
                newItems.add(new ContactExchange.Item(item.getJid(), item.getName(), specifiedGroups, ContactExchange.Item.Action.DELETE));
                continue;
            }
            if (item.getAction() != ContactExchange.Item.Action.MODIFY || contact == null) continue;
            newItems.add(item);
        }
        return newItems;
    }

    public Collection<Jid> getTrustedEntities() {
        return this.trustedEntities;
    }

    public void suggestContactAddition(Jid jid, Contact ... contacts) throws XmppException {
        if (contacts.length > 0) {
            ContactExchange contactExchange = new ContactExchange();
            for (Contact contact : contacts) {
                if (contact.getJid() == null) {
                    throw new IllegalArgumentException("Contact contains no JID.");
                }
                ContactExchange.Item rosterItem = new ContactExchange.Item(contact.getJid(), contact.getName(), (Collection)contact.getGroups(), ContactExchange.Item.Action.ADD);
                contactExchange.getItems().add(rosterItem);
            }
            Presence presence = ((PresenceManager)this.xmppSession.getManager(PresenceManager.class)).getPresence(jid);
            if (presence.isAvailable()) {
                this.xmppSession.query(new IQ(presence.getFrom(), AbstractIQ.Type.SET, (Object)contactExchange));
            } else {
                Message message = new Message(jid, AbstractMessage.Type.NORMAL);
                message.getExtensions().add(contactExchange);
                this.xmppSession.send((ClientStreamElement)message);
            }
        }
    }

    public ContactExchange.Item.Action approve(ContactExchange.Item item) throws XmppException {
        RosterManager rosterManager = (RosterManager)this.xmppSession.getManager(RosterManager.class);
        Contact contact = rosterManager.getContact(item.getJid());
        ContactExchange.Item.Action action = null;
        if (item.getAction() == null || item.getAction() == ContactExchange.Item.Action.ADD) {
            if (contact == null) {
                rosterManager.addContact(new Contact(item.getJid(), item.getName(), (Collection)item.getGroups()), true, null);
                action = ContactExchange.Item.Action.ADD;
            } else {
                ArrayList newGroups = new ArrayList(contact.getGroups());
                ArrayList additionalGroups = new ArrayList(item.getGroups());
                additionalGroups.removeAll(newGroups);
                if (!additionalGroups.isEmpty()) {
                    newGroups.addAll(additionalGroups);
                    rosterManager.updateContact(new Contact(contact.getJid(), contact.getName(), newGroups));
                    action = ContactExchange.Item.Action.MODIFY;
                }
            }
        } else if (item.getAction() == ContactExchange.Item.Action.DELETE) {
            if (contact != null) {
                ArrayList existingGroups = new ArrayList(contact.getGroups());
                ArrayList specifiedGroups = new ArrayList(item.getGroups());
                existingGroups.removeAll(specifiedGroups);
                if (!existingGroups.isEmpty()) {
                    rosterManager.updateContact(new Contact(contact.getJid(), contact.getName(), existingGroups));
                    action = ContactExchange.Item.Action.MODIFY;
                } else {
                    rosterManager.removeContact(item.getJid());
                    action = ContactExchange.Item.Action.DELETE;
                }
            }
        } else if (item.getAction() == ContactExchange.Item.Action.MODIFY && contact != null) {
            rosterManager.updateContact(new Contact(item.getJid(), item.getName(), (Collection)item.getGroups()));
            action = ContactExchange.Item.Action.MODIFY;
        }
        return action;
    }

    public void addContactExchangeListener(ContactExchangeListener contactExchangeListener) {
        this.contactExchangeListeners.add(contactExchangeListener);
    }

    public void removeContactExchangeListener(ContactExchangeListener contactExchangeListener) {
        this.contactExchangeListeners.remove(contactExchangeListener);
    }
}

