/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.rpc.RpcException;
import rocks.xmpp.extensions.rpc.RpcHandler;
import rocks.xmpp.extensions.rpc.model.Rpc;
import rocks.xmpp.extensions.rpc.model.Value;

public final class RpcManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(RpcManager.class.getName());
    private RpcHandler rpcHandler;

    private RpcManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"jabber:iq:rpc"});
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    RpcManager.this.rpcHandler = null;
                }
            }
        });
        this.xmppSession.addIQHandler(Rpc.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IQ processRequest(IQ iq) {
                RpcHandler rpcHandler1;
                Rpc rpc = (Rpc)iq.getExtension(Rpc.class);
                2 var4_3 = this;
                synchronized (var4_3) {
                    rpcHandler1 = RpcManager.this.rpcHandler;
                }
                if (rpcHandler1 != null) {
                    Rpc.MethodCall methodCall = rpc.getMethodCall();
                    ArrayList<Value> parameters = new ArrayList<Value>();
                    for (Value parameter : methodCall.getParameters()) {
                        parameters.add(parameter);
                    }
                    try {
                        Value value = rpcHandler1.process(iq.getFrom(), methodCall.getMethodName(), parameters);
                        return iq.createResult((Object)new Rpc(value));
                    }
                    catch (RpcException e1) {
                        return iq.createResult((Object)new Rpc(new Rpc.MethodResponse.Fault(e1.getFaultCode(), e1.getFaultString())));
                    }
                    catch (Throwable e1) {
                        logger.log(Level.WARNING, e1.getMessage(), e1);
                        return iq.createError(Condition.INTERNAL_SERVER_ERROR);
                    }
                }
                return iq.createError(Condition.SERVICE_UNAVAILABLE);
            }
        });
    }

    public Value call(Jid jid, String methodName, Value ... parameters) throws XmppException, RpcException {
        Rpc.MethodResponse methodResponse;
        Rpc rpc;
        IQ result = this.xmppSession.query(new IQ(jid, AbstractIQ.Type.SET, (Object)new Rpc(methodName, parameters)));
        if (result != null && (rpc = (Rpc)result.getExtension(Rpc.class)) != null && (methodResponse = rpc.getMethodResponse()) != null) {
            if (methodResponse.getFault() != null) {
                throw new RpcException(methodResponse.getFault().getFaultCode(), methodResponse.getFault().getFaultString());
            }
            return methodResponse.getResponse();
        }
        return null;
    }

    public synchronized void setRpcHandler(RpcHandler rpcHandler) {
        this.rpcHandler = rpcHandler;
        this.setEnabled(rpcHandler != null);
    }
}

