/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.si;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamEvent;
import rocks.xmpp.extensions.bytestreams.ByteStreamListener;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.InBandByteStreamManager;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5ByteStreamManager;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.featureneg.model.FeatureNegotiation;
import rocks.xmpp.extensions.filetransfer.FileTransfer;
import rocks.xmpp.extensions.filetransfer.FileTransferManager;
import rocks.xmpp.extensions.filetransfer.FileTransferNegotiator;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.si.model.StreamInitiation;
import rocks.xmpp.extensions.si.profile.filetransfer.model.SIFileTransferOffer;

public final class StreamInitiationManager
extends ExtensionManager
implements FileTransferNegotiator {
    private static final String STREAM_METHOD = "stream-method";
    private final Collection<String> supportedStreamMethod = new ArrayList<String>(Arrays.asList("http://jabber.org/protocol/bytestreams", "http://jabber.org/protocol/ibb"));
    private final Map<String, ProfileManager> profileManagers = new ConcurrentHashMap<String, ProfileManager>();
    private final InBandByteStreamManager inBandByteStreamManager;
    private final Socks5ByteStreamManager socks5ByteStreamManager;

    private StreamInitiationManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/si", "http://jabber.org/protocol/si/profile/file-transfer"});
        this.inBandByteStreamManager = (InBandByteStreamManager)xmppSession.getManager(InBandByteStreamManager.class);
        this.socks5ByteStreamManager = (Socks5ByteStreamManager)xmppSession.getManager(Socks5ByteStreamManager.class);
        this.profileManagers.put("http://jabber.org/protocol/si/profile/file-transfer", new ProfileManager(){

            @Override
            public void handle(IQ iq, StreamInitiation streamInitiation) {
                FileTransferManager fileTransferManager = (FileTransferManager)xmppSession.getManager(FileTransferManager.class);
                fileTransferManager.fileTransferOffered(iq, streamInitiation.getId(), streamInitiation.getMimeType(), (FileTransferOffer)streamInitiation.getProfileElement(), streamInitiation, StreamInitiationManager.this);
            }
        });
        this.setEnabled(true);
    }

    protected void initialize() {
        this.xmppSession.addIQHandler(StreamInitiation.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                DataForm.Field field;
                DataForm dataForm;
                StreamInitiation streamInitiation = (StreamInitiation)iq.getExtension(StreamInitiation.class);
                FeatureNegotiation featureNegotiation = streamInitiation.getFeatureNegotiation();
                boolean noValidStreams = true;
                if (featureNegotiation != null && (dataForm = featureNegotiation.getDataForm()) != null && (field = dataForm.findField(StreamInitiationManager.STREAM_METHOD)) != null) {
                    ArrayList<String> streamMethods = new ArrayList<String>();
                    for (DataForm.Option option : field.getOptions()) {
                        streamMethods.add(option.getValue());
                    }
                    if (!Collections.disjoint(streamMethods, StreamInitiationManager.this.supportedStreamMethod)) {
                        noValidStreams = false;
                    }
                }
                if (noValidStreams) {
                    return iq.createError(new StanzaError(Condition.BAD_REQUEST, StreamInitiation.NO_VALID_STREAMS));
                }
                ProfileManager profileManager = (ProfileManager)StreamInitiationManager.this.profileManagers.get(streamInitiation.getProfile());
                if (profileManager == null) {
                    return iq.createError(new StanzaError(Condition.BAD_REQUEST, StreamInitiation.BAD_PROFILE));
                }
                profileManager.handle(iq, streamInitiation);
                return null;
            }
        });
    }

    public OutputStream initiateStream(Jid receiver, SIFileTransferOffer profile, String mimeType, long timeout) throws XmppException, IOException {
        ByteStreamSession byteStreamSession;
        String streamMethod;
        String sessionId = UUID.randomUUID().toString();
        ArrayList<DataForm.Option> options = new ArrayList<DataForm.Option>();
        for (String streamMethod2 : this.supportedStreamMethod) {
            options.add(new DataForm.Option(streamMethod2));
        }
        DataForm.Field field = DataForm.Field.builder().var(STREAM_METHOD).type(DataForm.Field.Type.LIST_SINGLE).options(options).build();
        DataForm dataForm = new DataForm(DataForm.Type.FORM, Arrays.asList(field));
        IQ result = this.xmppSession.query(new IQ(receiver, AbstractIQ.Type.SET, (Object)new StreamInitiation(sessionId, "http://jabber.org/protocol/si/profile/file-transfer", mimeType, (Object)profile, new FeatureNegotiation(dataForm))), timeout);
        StreamInitiation streamInitiation = (StreamInitiation)result.getExtension(StreamInitiation.class);
        FeatureNegotiation featureNegotiation = streamInitiation.getFeatureNegotiation();
        switch (streamMethod = (String)featureNegotiation.getDataForm().findField(STREAM_METHOD).getValues().get(0)) {
            case "http://jabber.org/protocol/bytestreams": {
                try {
                    byteStreamSession = this.socks5ByteStreamManager.initiateSession(receiver, sessionId);
                }
                catch (Exception e) {
                    byteStreamSession = this.inBandByteStreamManager.initiateSession(receiver, sessionId, 4096);
                }
                break;
            }
            case "http://jabber.org/protocol/ibb": {
                byteStreamSession = this.inBandByteStreamManager.initiateSession(receiver, sessionId, 4096);
                break;
            }
            default: {
                throw new IOException("Receiver returned unsupported stream method.");
            }
        }
        return byteStreamSession.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileTransfer accept(IQ iq, final String sessionId, FileTransferOffer fileTransferOffer, Object protocol, OutputStream outputStream) throws IOException {
        StreamInitiation streamInitiation = (StreamInitiation)protocol;
        DataForm.Field field = streamInitiation.getFeatureNegotiation().getDataForm().findField(STREAM_METHOD);
        ArrayList<String> offeredStreamMethods = new ArrayList<String>();
        for (DataForm.Option option : field.getOptions()) {
            offeredStreamMethods.add(option.getValue());
        }
        offeredStreamMethods.retainAll(this.supportedStreamMethod);
        DataForm.Field fieldReply = DataForm.Field.builder().var(STREAM_METHOD).values(offeredStreamMethods).type(DataForm.Field.Type.LIST_SINGLE).build();
        DataForm dataForm = new DataForm(DataForm.Type.SUBMIT, Collections.singleton(fieldReply));
        StreamInitiation siResponse = new StreamInitiation(new FeatureNegotiation(dataForm));
        final ReentrantLock lock = new ReentrantLock();
        final java.util.concurrent.locks.Condition byteStreamOpened = lock.newCondition();
        final ByteStreamSession[] byteStreamSessions = new ByteStreamSession[1];
        final ArrayList negotiationExceptions = new ArrayList();
        ByteStreamListener byteStreamListener = new ByteStreamListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void byteStreamRequested(ByteStreamEvent e) {
                if (sessionId.equals(e.getSessionId())) {
                    lock.lock();
                    try {
                        byteStreamSessions[0] = e.accept();
                        byteStreamOpened.signal();
                    }
                    catch (Exception e1) {
                        negotiationExceptions.add(e1);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        };
        try {
            this.socks5ByteStreamManager.addByteStreamListener(byteStreamListener);
            this.inBandByteStreamManager.addByteStreamListener(byteStreamListener);
            this.xmppSession.send((ClientStreamElement)iq.createResult((Object)siResponse));
            lock.lock();
            try {
                if (!byteStreamOpened.await(this.xmppSession.getConfiguration().getDefaultResponseTimeout(), TimeUnit.MILLISECONDS)) {
                    throw new IOException("No byte stream could be negotiated in time.", negotiationExceptions.isEmpty() ? null : (Exception)negotiationExceptions.get(0));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                lock.unlock();
            }
            byteStreamSessions[0].setReadTimeout(this.xmppSession.getConfiguration().getDefaultResponseTimeout());
            FileTransfer fileTransfer = new FileTransfer(byteStreamSessions[0].getInputStream(), outputStream, fileTransferOffer.getSize());
            return fileTransfer;
        }
        finally {
            this.inBandByteStreamManager.removeByteStreamListener(byteStreamListener);
            this.socks5ByteStreamManager.removeByteStreamListener(byteStreamListener);
        }
    }

    @Override
    public void reject(IQ iq) {
        this.xmppSession.send((ClientStreamElement)iq.createError(Condition.FORBIDDEN));
    }

    private static interface ProfileManager {
        public void handle(IQ var1, StreamInitiation var2);
    }
}

