/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.vcard.temp;

import java.util.Objects;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.subscription.PresenceManager;
import rocks.xmpp.extensions.avatar.AvatarManager;
import rocks.xmpp.extensions.vcard.temp.model.VCard;

public final class VCardManager
extends ExtensionManager {
    private VCardManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"vcard-temp"});
        this.setEnabled(true);
    }

    public VCard getVCard() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(AbstractIQ.Type.GET, (Object)new VCard()));
        return (VCard)result.getExtension(VCard.class);
    }

    public void setVCard(VCard vCard) throws XmppException {
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)vCard));
        AvatarManager avatarManager = (AvatarManager)this.xmppSession.getManager(AvatarManager.class);
        if (this.isEnabled() && avatarManager.isEnabled()) {
            Presence presence = ((PresenceManager)this.xmppSession.getManager(PresenceManager.class)).getLastSentPresence();
            if (presence == null) {
                presence = new Presence();
            }
            presence.getExtensions().clear();
            this.xmppSession.send((ClientStreamElement)presence);
        }
    }

    public VCard getVCard(Jid jid) throws XmppException {
        Objects.requireNonNull(jid, "jid must not be null.");
        IQ result = this.xmppSession.query(new IQ(jid.asBareJid(), AbstractIQ.Type.GET, (Object)new VCard()));
        return (VCard)result.getExtension(VCard.class);
    }
}

