/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.IbbEvent;
import rocks.xmpp.extensions.bytestreams.ibb.IbbSession;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;
import rocks.xmpp.util.XmppUtils;

public final class InBandByteStreamManager
extends ByteStreamManager {
    private static final Logger logger = Logger.getLogger(InBandByteStreamManager.class.getName());
    final Map<String, IbbSession> ibbSessionMap = new ConcurrentHashMap<String, IbbSession>();
    private final IQHandler openIQHandler;
    private final IQHandler dataIQHandler;
    private final IQHandler closeIQHandler;
    private final Consumer<MessageEvent> messageListener;

    private InBandByteStreamManager(final XmppSession xmppSession) {
        super(xmppSession);
        this.openIQHandler = new AbstractIQHandler(IQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                InBandByteStream.Open open = (InBandByteStream.Open)iq.getExtension(InBandByteStream.Open.class);
                if (open.getBlockSize() > 65535) {
                    return iq.createError(new StanzaError(StanzaError.Type.MODIFY, Condition.RESOURCE_CONSTRAINT));
                }
                XmppUtils.notifyEventListeners((Iterable)InBandByteStreamManager.this.byteStreamListeners, (EventObject)new IbbEvent((Object)InBandByteStreamManager.this, open.getSessionId(), xmppSession, iq, open.getBlockSize()));
                return null;
            }
        };
        this.dataIQHandler = new AbstractIQHandler(IQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                InBandByteStream.Data data = (InBandByteStream.Data)iq.getExtension(InBandByteStream.Data.class);
                IbbSession ibbSession = InBandByteStreamManager.this.ibbSessionMap.get(data.getSessionId());
                if (ibbSession != null) {
                    if (ibbSession.dataReceived(data)) {
                        return iq.createResult();
                    }
                    return iq.createError(new StanzaError(StanzaError.Type.CANCEL, Condition.UNEXPECTED_REQUEST));
                }
                return iq.createError(Condition.ITEM_NOT_FOUND);
            }
        };
        this.closeIQHandler = new AbstractIQHandler(IQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                InBandByteStream.Close close = (InBandByteStream.Close)iq.getExtension(InBandByteStream.Close.class);
                IbbSession ibbSession = InBandByteStreamManager.this.ibbSessionMap.get(close.getSessionId());
                if (ibbSession != null) {
                    try {
                        InBandByteStreamManager.this.ibbSessionMap.remove(close.getSessionId());
                        ibbSession.closedByPeer();
                        return iq.createResult();
                    }
                    catch (IOException e1) {
                        logger.log(Level.WARNING, e1.getMessage(), e1);
                        return iq.createResult();
                    }
                }
                return iq.createError(Condition.ITEM_NOT_FOUND);
            }
        };
        this.messageListener = e -> {
            InBandByteStream.Data data;
            if (this.isEnabled() && (data = (InBandByteStream.Data)e.getMessage().getExtension(InBandByteStream.Data.class)) != null) {
                IbbSession ibbSession = this.ibbSessionMap.get(data.getSessionId());
                if (ibbSession != null) {
                    if (!ibbSession.dataReceived(data)) {
                        xmppSession.send((StreamElement)e.getMessage().createError(new StanzaError(StanzaError.Type.CANCEL, Condition.UNEXPECTED_REQUEST)));
                    }
                } else {
                    xmppSession.send((StreamElement)e.getMessage().createError(Condition.ITEM_NOT_FOUND));
                }
            }
        };
    }

    protected final void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(InBandByteStream.Open.class, this.openIQHandler, false);
        this.xmppSession.addIQHandler(InBandByteStream.Data.class, this.dataIQHandler, false);
        this.xmppSession.addIQHandler(InBandByteStream.Close.class, this.closeIQHandler, false);
        this.xmppSession.addInboundMessageListener(this.messageListener);
    }

    protected final void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(InBandByteStream.Open.class);
        this.xmppSession.removeIQHandler(InBandByteStream.Data.class);
        this.xmppSession.removeIQHandler(InBandByteStream.Close.class);
        this.xmppSession.removeInboundMessageListener(this.messageListener);
    }

    IbbSession createSession(Jid receiver, String sessionId, int blockSize) {
        IbbSession ibbSession = new IbbSession(sessionId, this.xmppSession, receiver, blockSize, this);
        this.ibbSessionMap.put(ibbSession.getSessionId(), ibbSession);
        return ibbSession;
    }

    public final ByteStreamSession initiateSession(Jid receiver, String sessionId, int blockSize) throws XmppException {
        if (blockSize > 65535) {
            throw new IllegalArgumentException("blockSize must not be greater than 65535.");
        }
        IbbSession ibbSession = this.createSession(receiver, sessionId, blockSize);
        ibbSession.open();
        return ibbSession;
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.ibbSessionMap.clear();
    }
}

