/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5Protocol;

final class LocalSocks5Server {
    private static final Logger logger = Logger.getLogger(LocalSocks5Server.class.getName());
    final Collection<String> allowedAddresses = new CopyOnWriteArrayList<String>();
    private int port = 1080;
    private volatile ServerSocket serverSocket;
    private final Map<String, Socket> socketMap = new ConcurrentHashMap<String, Socket>();

    LocalSocks5Server() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.serverSocket == null) {
            LocalSocks5Server localSocks5Server = this;
            synchronized (localSocks5Server) {
                if (this.serverSocket == null) {
                    try {
                        this.serverSocket = new ServerSocket(this.getPort());
                        Thread thread = new Thread(() -> {
                            while (this.serverSocket != null) {
                                Socket socket = null;
                                try {
                                    socket = this.serverSocket.accept();
                                    this.socketMap.put(Socks5Protocol.establishServerConnection(socket, this.allowedAddresses), socket);
                                }
                                catch (IOException e) {
                                    if (socket == null) continue;
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException e1) {
                                        logger.log(Level.WARNING, e.getMessage(), e);
                                    }
                                }
                            }
                        });
                        thread.setDaemon(true);
                        thread.start();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public Socket getSocket(String destinationAddress) {
        return this.socketMap.remove(destinationAddress);
    }

    void removeConnection(String destinationAddress) {
        this.allowedAddresses.remove(destinationAddress);
        this.socketMap.remove(destinationAddress);
    }
}

