/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.muc.InvitationDeclineEvent;
import rocks.xmpp.extensions.muc.MultiUserChatManager;
import rocks.xmpp.extensions.muc.Occupant;
import rocks.xmpp.extensions.muc.OccupantEvent;
import rocks.xmpp.extensions.muc.RoomInformation;
import rocks.xmpp.extensions.muc.SubjectChangeEvent;
import rocks.xmpp.extensions.muc.conference.model.DirectInvitation;
import rocks.xmpp.extensions.muc.model.Actor;
import rocks.xmpp.extensions.muc.model.Affiliation;
import rocks.xmpp.extensions.muc.model.DiscussionHistory;
import rocks.xmpp.extensions.muc.model.Item;
import rocks.xmpp.extensions.muc.model.Muc;
import rocks.xmpp.extensions.muc.model.MucFeature;
import rocks.xmpp.extensions.muc.model.RequestVoice;
import rocks.xmpp.extensions.muc.model.Role;
import rocks.xmpp.extensions.muc.model.RoomConfiguration;
import rocks.xmpp.extensions.muc.model.RoomInfo;
import rocks.xmpp.extensions.muc.model.admin.MucAdmin;
import rocks.xmpp.extensions.muc.model.owner.MucOwner;
import rocks.xmpp.extensions.muc.model.user.Decline;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.muc.model.user.Status;
import rocks.xmpp.extensions.register.model.Registration;
import rocks.xmpp.im.chat.Chat;
import rocks.xmpp.util.XmppUtils;

public final class ChatRoom
extends Chat
implements Comparable<ChatRoom> {
    private final Set<Consumer<InvitationDeclineEvent>> invitationDeclineListeners = new CopyOnWriteArraySet<Consumer<InvitationDeclineEvent>>();
    private final Set<Consumer<SubjectChangeEvent>> subjectChangeListeners = new CopyOnWriteArraySet<Consumer<SubjectChangeEvent>>();
    private final Set<Consumer<OccupantEvent>> occupantListeners = new CopyOnWriteArraySet<Consumer<OccupantEvent>>();
    private final Map<String, Occupant> occupantMap = new HashMap<String, Occupant>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final MultiUserChatManager multiUserChatManager;
    private final String name;
    private final Jid roomJid;
    private final XmppSession xmppSession;
    private final Consumer<MessageEvent> messageListener;
    private final Consumer<PresenceEvent> presenceListener;
    private volatile String nick;
    private volatile boolean entered;

    ChatRoom(Jid roomJid, String name, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager, MultiUserChatManager multiUserChatManager) {
        this.name = name;
        this.roomJid = roomJid;
        this.xmppSession = xmppSession;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.multiUserChatManager = multiUserChatManager;
        this.messageListener = e -> {
            Message message = e.getMessage();
            if (message.getFrom().asBareJid().equals((Object)roomJid)) {
                if (message.getType() == Message.Type.GROUPCHAT) {
                    if (message.getSubject() != null && message.getBody() == null) {
                        XmppUtils.notifyEventListeners(this.subjectChangeListeners, (EventObject)new SubjectChangeEvent(this, message.getSubject(), message.getFrom().getResource(), message.hasExtension(DelayedDelivery.class), DelayedDelivery.sendDate((Stanza)message)));
                    } else {
                        XmppUtils.notifyEventListeners((Iterable)this.inboundMessageListeners, (EventObject)new MessageEvent((Object)this, message, true));
                    }
                } else {
                    Decline decline;
                    MucUser mucUser = (MucUser)message.getExtension(MucUser.class);
                    if (mucUser != null && (decline = mucUser.getDecline()) != null) {
                        XmppUtils.notifyEventListeners(this.invitationDeclineListeners, (EventObject)new InvitationDeclineEvent(this, roomJid, decline.getFrom(), decline.getReason()));
                    }
                }
            }
        };
        this.presenceListener = e -> {
            String nick;
            MucUser mucUser;
            Presence presence = e.getPresence();
            if (presence.getFrom() != null && presence.getFrom().asBareJid().equals((Object)roomJid) && (mucUser = (MucUser)presence.getExtension(MucUser.class)) != null && (nick = presence.getFrom().getResource()) != null) {
                boolean isSelfPresence = this.isSelfPresence(presence);
                if (presence.isAvailable()) {
                    Occupant occupant = new Occupant(presence, isSelfPresence);
                    Occupant previousOccupant = this.occupantMap.put(nick, occupant);
                    if (previousOccupant == null) {
                        if (!isSelfPresence && this.entered) {
                            XmppUtils.notifyEventListeners(this.occupantListeners, (EventObject)new OccupantEvent(this, occupant, OccupantEvent.Type.ENTERED, null, null, null));
                        }
                    } else {
                        XmppUtils.notifyEventListeners(this.occupantListeners, (EventObject)new OccupantEvent(this, occupant, OccupantEvent.Type.STATUS_CHANGED, null, null, null));
                    }
                } else if (presence.getType() == Presence.Type.UNAVAILABLE) {
                    Occupant occupant = this.occupantMap.remove(nick);
                    if (occupant != null) {
                        OccupantEvent occupantEvent = null;
                        if (mucUser.getItem() != null) {
                            Actor actor = mucUser.getItem().getActor();
                            String reason = mucUser.getItem().getReason();
                            if (!mucUser.getStatusCodes().isEmpty()) {
                                if (mucUser.getStatusCodes().contains(Status.KICKED)) {
                                    occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.KICKED, actor, reason, null);
                                } else if (mucUser.getStatusCodes().contains(Status.BANNED)) {
                                    occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.BANNED, actor, reason, null);
                                } else if (mucUser.getStatusCodes().contains(Status.MEMBERSHIP_REVOKED)) {
                                    occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.MEMBERSHIP_REVOKED, actor, reason, null);
                                } else if (mucUser.getStatusCodes().contains(Status.NICK_CHANGED)) {
                                    occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.NICKNAME_CHANGED, actor, reason, null);
                                } else if (mucUser.getStatusCodes().contains(Status.SERVICE_SHUT_DOWN)) {
                                    occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.SYSTEM_SHUTDOWN, actor, reason, null);
                                }
                            } else {
                                occupantEvent = mucUser.getDestroy() != null ? new OccupantEvent(this, occupant, OccupantEvent.Type.ROOM_DESTROYED, actor, mucUser.getDestroy().getReason(), mucUser.getDestroy().getJid()) : new OccupantEvent(this, occupant, OccupantEvent.Type.EXITED, null, null, null);
                            }
                        } else {
                            occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.EXITED, null, null, null);
                        }
                        if (occupantEvent != null) {
                            XmppUtils.notifyEventListeners(this.occupantListeners, (EventObject)occupantEvent);
                        }
                    }
                    if (isSelfPresence) {
                        this.userHasExited();
                    }
                }
            }
        };
    }

    void initialize() {
        this.xmppSession.addSessionStatusListener(e -> {
            if (e.getStatus() == XmppSession.Status.CLOSED) {
                this.invitationDeclineListeners.clear();
                this.subjectChangeListeners.clear();
                this.occupantListeners.clear();
                this.inboundMessageListeners.clear();
                this.occupantMap.clear();
            }
        });
    }

    private void userHasExited() {
        this.xmppSession.removeInboundMessageListener(this.messageListener);
        this.xmppSession.removeInboundPresenceListener(this.presenceListener);
    }

    private boolean isSelfPresence(Presence presence) {
        boolean isSelfPresence = false;
        MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
        if (mucUser != null) {
            boolean nicknameChanged = mucUser.getStatusCodes().contains(Status.SERVICE_HAS_ASSIGNED_OR_MODIFIED_NICK);
            if (nicknameChanged) {
                this.nick = presence.getFrom().getResource();
            }
            isSelfPresence = mucUser.getStatusCodes().contains(Status.SELF_PRESENCE) || nicknameChanged;
        }
        return isSelfPresence || this.nick != null && presence.getFrom() != null && this.nick.equals(presence.getFrom().getResource());
    }

    public void addInvitationDeclineListener(Consumer<InvitationDeclineEvent> invitationDeclineListener) {
        this.invitationDeclineListeners.add(invitationDeclineListener);
    }

    public void removeInvitationDeclineListener(Consumer<InvitationDeclineEvent> invitationDeclineListener) {
        this.invitationDeclineListeners.remove(invitationDeclineListener);
    }

    public void addSubjectChangeListener(Consumer<SubjectChangeEvent> subjectChangeListener) {
        this.subjectChangeListeners.add(subjectChangeListener);
    }

    public void removeSubjectChangeListener(Consumer<SubjectChangeEvent> subjectChangeListener) {
        this.subjectChangeListeners.remove(subjectChangeListener);
    }

    public void addOccupantListener(Consumer<OccupantEvent> occupantListener) {
        this.occupantListeners.add(occupantListener);
    }

    public void removeOccupantListener(Consumer<OccupantEvent> occupantListener) {
        this.occupantListeners.remove(occupantListener);
    }

    public void enter(String nick) throws XmppException {
        this.enter(nick, null, null);
    }

    public void enter(String nick, String password) throws XmppException {
        this.enter(nick, password, null);
    }

    public void enter(String nick, DiscussionHistory discussionHistory) throws XmppException {
        this.enter(nick, null, discussionHistory);
    }

    public synchronized void enter(String nick, String password, DiscussionHistory discussionHistory) throws XmppException {
        Objects.requireNonNull(nick, "nick must not be null.");
        if (this.entered) {
            throw new IllegalStateException("You already entered this room.");
        }
        try {
            this.xmppSession.addInboundMessageListener(this.messageListener);
            this.xmppSession.addInboundPresenceListener(this.presenceListener);
            Presence enterPresence = new Presence(this.roomJid.withResource(nick));
            enterPresence.addExtension((Object)Muc.withPasswordAndHistory((String)password, (DiscussionHistory)discussionHistory));
            this.nick = nick;
            this.xmppSession.sendAndAwaitPresence((StreamElement)enterPresence, presence -> {
                Jid room = presence.getFrom().asBareJid();
                return presence.isAvailable() && room.equals((Object)this.roomJid) && this.isSelfPresence((Presence)presence);
            });
        }
        catch (XmppException e) {
            this.xmppSession.removeInboundMessageListener(this.messageListener);
            this.xmppSession.removeInboundPresenceListener(this.presenceListener);
            throw e;
        }
        this.multiUserChatManager.roomEntered(this, nick);
        this.entered = true;
    }

    public void changeSubject(String subject) throws XmppException {
        Message message = new Message(this.roomJid, Message.Type.GROUPCHAT, null, subject, null);
        this.xmppSession.sendAndAwaitMessage((StreamElement)message, message1 -> message1.getSubject() != null && message1.getSubject().equals(subject));
    }

    public Message sendMessage(String message) {
        Message m = new Message(this.roomJid, Message.Type.GROUPCHAT, message);
        this.xmppSession.send((StreamElement)m);
        return m;
    }

    public Message sendMessage(Message message) {
        Message m = new Message(this.roomJid, Message.Type.GROUPCHAT, (Collection)message.getBodies(), (Collection)message.getSubjects(), message.getThread(), message.getParentThread(), message.getId(), message.getFrom(), message.getLanguage(), (Collection)message.getExtensions(), message.getError());
        this.xmppSession.send((StreamElement)m);
        return m;
    }

    public synchronized void changeNickname(String newNickname) throws XmppException {
        if (!this.entered) {
            throw new IllegalStateException("You must have entered the room to change your nickname.");
        }
        Presence changeNickNamePresence = new Presence(this.roomJid.withResource(newNickname));
        this.xmppSession.sendAndAwaitPresence((StreamElement)changeNickNamePresence, presence2 -> presence2.getFrom().equals((Object)changeNickNamePresence.getTo()));
    }

    public synchronized void changeAvailabilityStatus(Presence.Show show, String status) {
        if (!this.entered) {
            throw new IllegalStateException("You must have entered the room to change the availability status.");
        }
        this.xmppSession.send((StreamElement)new Presence(this.roomJid.withResource(this.nick), show, status));
    }

    public void invite(Jid invitee, String reason) {
        this.invite(invitee, reason, false);
    }

    public void invite(Jid invitee, String reason, boolean direct) {
        Message message;
        if (direct) {
            message = new Message(invitee, Message.Type.NORMAL);
            message.addExtension((Object)new DirectInvitation(this.roomJid, null, reason));
        } else {
            message = new Message(this.roomJid, Message.Type.NORMAL);
            message.addExtension((Object)MucUser.withInvites((Invite[])new Invite[]{new Invite(invitee, reason)}));
        }
        this.xmppSession.send((StreamElement)message);
    }

    public DataForm getRegistrationForm() throws XmppException {
        IQ iq = IQ.get((Jid)this.roomJid, (Object)Registration.empty());
        IQ result = this.xmppSession.query(iq);
        Registration registration = (Registration)result.getExtension(Registration.class);
        if (registration != null) {
            return registration.getRegistrationForm();
        }
        return null;
    }

    public void register(Registration registration) throws XmppException {
        Objects.requireNonNull(registration, "registration must not be null.");
        if (registration.getRegistrationForm() != null) {
            if (registration.getRegistrationForm().getType() != DataForm.Type.SUBMIT) {
                throw new IllegalArgumentException("Data Form must be of type 'submit'");
            }
            if (!"http://jabber.org/protocol/muc#register".equals(registration.getRegistrationForm().getFormType())) {
                throw new IllegalArgumentException("Data Form is not of type 'http://jabber.org/protocol/muc#register'");
            }
        }
        this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)registration));
    }

    public String discoverReservedNickname() throws XmppException {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getManager(ServiceDiscoveryManager.class);
        InfoNode infoNode = serviceDiscoveryManager.discoverInformation(this.roomJid, "x-roomuser-item");
        if (infoNode != null) {
            for (Identity identity : infoNode.getIdentities()) {
                if (!"conference".equals(identity.getCategory()) || !"text".equals(identity.getType())) continue;
                return identity.getName();
            }
        }
        return null;
    }

    public void requestVoice() {
        Message message = new Message(this.roomJid);
        RequestVoice requestVoice = RequestVoice.builder().role(Role.PARTICIPANT).build();
        message.addExtension((Object)requestVoice.getDataForm());
        this.xmppSession.send((StreamElement)message);
    }

    public void exit() throws XmppException {
        this.exit(null);
    }

    public synchronized void exit(String message) throws XmppException {
        if (!this.entered) {
            throw new IllegalStateException("You can't exit a room, when you didn't enter it.");
        }
        this.xmppSession.sendAndAwaitPresence((StreamElement)new Presence(this.roomJid.withResource(this.nick), Presence.Type.UNAVAILABLE, message), presence -> {
            Jid room = presence.getFrom().asBareJid();
            return !presence.isAvailable() && room.equals((Object)this.roomJid) && this.isSelfPresence((Presence)presence);
        });
        this.userHasExited();
        this.nick = null;
        this.multiUserChatManager.roomExited(this);
        this.entered = false;
        this.occupantMap.clear();
    }

    public List<? extends Item> getVoiceList() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucAdmin.withItem((Role)Role.PARTICIPANT, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void changeAffiliationsOrRoles(List<Item> items) throws XmppException {
        this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)MucAdmin.withItems(items)));
    }

    public List<? extends Item> getBanList() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucAdmin.withItem((Affiliation)Affiliation.OUTCAST, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void changeAffiliation(Affiliation affiliation, Jid user, String reason) throws XmppException {
        this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)MucAdmin.withItem((Affiliation)affiliation, (Jid)user, (String)reason)));
    }

    public void changeRole(Role role, String nickname, String reason) throws XmppException {
        this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)MucAdmin.withItem((Role)role, (String)nickname, (String)reason)));
    }

    public List<? extends Item> getMembers() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucAdmin.withItem((Affiliation)Affiliation.MEMBER, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public List<? extends Item> getModerators() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucAdmin.withItem((Role)Role.MODERATOR, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void createRoom() throws XmppException {
        this.enter(this.nick);
        this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)MucOwner.withConfiguration((DataForm)new DataForm(DataForm.Type.SUBMIT))));
    }

    public RoomInformation getRoomInformation() throws XmppException {
        InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(this.roomJid);
        Identity identity = null;
        HashSet<MucFeature> mucFeatures = new HashSet<MucFeature>();
        RoomInfo roomInfo = null;
        if (infoNode != null) {
            Set identities = infoNode.getIdentities();
            Iterator iterator = identities.iterator();
            if (iterator.hasNext()) {
                identity = (Identity)iterator.next();
            }
            for (String feature : infoNode.getFeatures()) {
                for (MucFeature mucFeature : MucFeature.values()) {
                    if (!mucFeature.getServiceDiscoveryFeature().equals(feature)) continue;
                    mucFeatures.add(mucFeature);
                }
            }
            for (DataForm dataForm : infoNode.getExtensions()) {
                String formType = dataForm.getFormType();
                if (!"http://jabber.org/protocol/muc#roominfo".equals(formType)) continue;
                roomInfo = new RoomInfo(dataForm);
                break;
            }
        }
        return new RoomInformation(identity, mucFeatures, roomInfo);
    }

    public List<String> discoverOccupants() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.roomJid);
        ArrayList<String> occupants = new ArrayList<String>();
        List items = itemNode.getItems();
        items.stream().filter(item -> item.getJid() != null).forEach(item -> {
            String nickname = item.getJid().getResource();
            if (nickname != null) {
                occupants.add(nickname);
            }
        });
        return occupants;
    }

    public Collection<Occupant> getOccupants() {
        return this.occupantMap.values();
    }

    public Occupant getOccupant(String nickname) {
        return this.occupantMap.get(nickname);
    }

    public DataForm getConfigurationForm() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucOwner.empty()));
        MucOwner mucOwner = (MucOwner)result.getExtension(MucOwner.class);
        return mucOwner.getConfigurationForm();
    }

    public void configure(RoomConfiguration roomConfiguration) throws XmppException {
        Objects.requireNonNull(roomConfiguration, "roomConfiguration must not be null.");
        MucOwner mucOwner = MucOwner.withConfiguration((DataForm)roomConfiguration.getDataForm());
        this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)mucOwner));
    }

    public String getName() {
        return this.name;
    }

    public void destroy(String reason) throws XmppException {
        MucOwner mucOwner = MucOwner.withDestroy((Jid)this.roomJid, (String)reason);
        this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)mucOwner));
    }

    public Jid getAddress() {
        return this.roomJid;
    }

    public Set<String> discoverAllowableTraffic() throws XmppException {
        return this.serviceDiscoveryManager.discoverInformation(this.roomJid, "http://jabber.org/protocol/muc#traffic").getFeatures();
    }

    public String toString() {
        return this.roomJid != null ? this.roomJid.toString() : super.toString();
    }

    @Override
    public int compareTo(ChatRoom o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result;
            if (this.name != null) {
                result = o.name != null ? this.name.compareTo(o.name) : -1;
            } else {
                int n = result = o.name != null ? 1 : 0;
            }
            if (result == 0) {
                if (this.roomJid != null) {
                    return o.roomJid != null ? this.roomJid.compareTo(o.roomJid) : -1;
                }
                return o.roomJid != null ? 1 : 0;
            }
            return result;
        }
        return -1;
    }
}

