/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.ping;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.StanzaException;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.ping.model.Ping;
import rocks.xmpp.util.XmppUtils;

public final class PingManager
extends Manager {
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP Scheduled Ping Thread"));
    private ScheduledFuture<?> nextPing;
    private long pingInterval = 900L;
    private final IQHandler iqHandler = new AbstractIQHandler(IQ.Type.GET){

        protected IQ processRequest(IQ iq) {
            return iq.createResult();
        }
    };
    private final Consumer<MessageEvent> inboundMessageListener = e -> this.rescheduleNextPing();
    private final Consumer<PresenceEvent> inboundPresenceListener = e -> this.rescheduleNextPing();
    private final Consumer<IQEvent> inboundIQListener = e -> this.rescheduleNextPing();

    private PingManager(XmppSession xmppSession) {
        super(xmppSession, true);
    }

    protected final void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(Ping.class, this.iqHandler);
        this.xmppSession.addInboundMessageListener(this.inboundMessageListener);
        this.xmppSession.addInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.addInboundIQListener(this.inboundIQListener);
        this.rescheduleNextPing();
    }

    protected final void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(Ping.class);
        this.xmppSession.removeInboundMessageListener(this.inboundMessageListener);
        this.xmppSession.removeInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.removeInboundIQListener(this.inboundIQListener);
        this.cancelNextPing();
    }

    public final boolean ping(Jid jid) {
        return this.ping(jid, this.xmppSession.getConfiguration().getDefaultResponseTimeout());
    }

    public final boolean ping(Jid jid, long timeout) {
        try {
            this.xmppSession.query(IQ.get((Jid)jid, (Object)Ping.INSTANCE), timeout);
            return true;
        }
        catch (StanzaException e) {
            return (jid == null || jid.isBareJid()) && e.getStanza().getError().getCondition() == Condition.SERVICE_UNAVAILABLE;
        }
        catch (XmppException e) {
            return false;
        }
    }

    public final boolean pingServer() {
        return this.ping(this.xmppSession.getDomain());
    }

    public final synchronized long getPingInterval() {
        return this.pingInterval;
    }

    public final synchronized void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
        this.rescheduleNextPing();
    }

    private synchronized void rescheduleNextPing() {
        if (this.pingInterval > 0L && !this.scheduledExecutorService.isShutdown()) {
            this.cancelNextPing();
            this.nextPing = this.scheduledExecutorService.schedule(() -> {
                if (this.isEnabled() && this.xmppSession.getStatus() == XmppSession.Status.AUTHENTICATED && !this.pingServer()) {
                    try {
                        throw new XmppException("Server ping failed.");
                    }
                    catch (XmppException e) {
                        this.xmppSession.notifyException((Throwable)e);
                    }
                }
            }, this.pingInterval, TimeUnit.SECONDS);
        }
    }

    private synchronized void cancelNextPing() {
        if (this.nextPing != null) {
            this.nextPing.cancel(false);
            this.nextPing = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        PingManager pingManager = this;
        synchronized (pingManager) {
            this.cancelNextPing();
            this.scheduledExecutorService.shutdown();
        }
    }
}

