/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.pubsub.PubSubNode;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.NodeType;
import rocks.xmpp.extensions.pubsub.model.PubSub;
import rocks.xmpp.extensions.pubsub.model.PubSubFeature;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;

public final class PubSubService {
    private static final Logger logger = Logger.getLogger(PubSubService.class.getName());
    private final Jid service;
    private final String name;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final XmppSession xmppSession;

    PubSubService(Jid service, String name, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager) {
        this.service = service;
        this.name = name;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.xmppSession = xmppSession;
    }

    public Collection<PubSubFeature> discoverFeatures() throws XmppException {
        InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(this.service);
        return this.getFeatures(infoNode);
    }

    Collection<PubSubFeature> getFeatures(InfoNode infoNode) {
        EnumSet<PubSubFeature> features = EnumSet.noneOf(PubSubFeature.class);
        infoNode.getFeatures().stream().filter(feature -> feature.startsWith("http://jabber.org/protocol/pubsub#")).forEach(feature -> {
            String f = feature.substring(feature.indexOf(35) + 1);
            try {
                PubSubFeature pubSubFeature = PubSubFeature.valueOf((String)f.toUpperCase().replace('-', '_'));
                if (pubSubFeature != null) {
                    features.add(pubSubFeature);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Server advertised unknown pubsub feature: {0}", f);
            }
        });
        return features;
    }

    public List<PubSubNode> discoverNodes() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.service);
        return itemNode.getItems().stream().map(item -> new PubSubNode(item.getNode(), this.service, this.xmppSession)).collect(Collectors.toList());
    }

    public PubSubNode node(String node) {
        return new PubSubNode(node, NodeType.LEAF, this.service, this.xmppSession);
    }

    private List<Subscription> getSubscriptions() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.service, (Object)PubSub.withSubscriptions()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getSubscriptions();
    }

    private List<Affiliation> getAffiliations() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.service, (Object)PubSub.withAffiliations()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getAffiliations();
    }

    private DataForm getDefaultSubscriptionOptions() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.service, (Object)PubSub.withDefault()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getDefault().getDataForm();
    }

    private DataForm getDefaultNodeConfiguration() throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)this.service, (Object)PubSubOwner.withDefault()));
        PubSubOwner pubSubOwner = (PubSubOwner)result.getExtension(PubSubOwner.class);
        return pubSubOwner.getConfigurationForm();
    }

    public Jid getAddress() {
        return this.service;
    }

    public String toString() {
        return this.service.toString();
    }

    public String getName() {
        return this.name;
    }
}

