/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rtt;

import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.rtt.RealTimeMessage;
import rocks.xmpp.extensions.rtt.model.RealTimeText;
import rocks.xmpp.im.chat.Chat;
import rocks.xmpp.util.XmppUtils;

public final class OutboundRealTimeMessage
extends RealTimeMessage {
    private static final Random RANDOM = new SecureRandom();
    private final List<RealTimeText.Action> actions = new ArrayList<RealTimeText.Action>();
    private final Chat chat;
    private final ScheduledExecutorService transmissionExecutor;
    private final ScheduledExecutorService refreshExecutor;
    private String text;
    private ScheduledFuture<?> nextRefresh;
    private ScheduledFuture<?> nextTransmission;
    private long lastTextChange;
    private final long refreshInterval;
    private final long transmissionInterval;
    private boolean isNew = true;

    OutboundRealTimeMessage(Chat chat, String id, final long transmissionInterval, final long refreshInterval) {
        this.chat = chat;
        this.id = id;
        this.transmissionInterval = transmissionInterval;
        this.refreshInterval = refreshInterval;
        this.transmissionExecutor = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory((String)"Real-time Text Transmission Thread"));
        this.refreshExecutor = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory((String)"Real-time Text Refresh Thread"));
        this.nextTransmission = this.transmissionExecutor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutboundRealTimeMessage outboundRealTimeMessage = OutboundRealTimeMessage.this;
                synchronized (outboundRealTimeMessage) {
                    if (!OutboundRealTimeMessage.this.actions.isEmpty()) {
                        if (OutboundRealTimeMessage.this.isNew) {
                            OutboundRealTimeMessage.this.sequence = OutboundRealTimeMessage.generateSequenceNumber();
                            OutboundRealTimeMessage.this.nextRefresh = OutboundRealTimeMessage.this.refreshExecutor.schedule(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    OutboundRealTimeMessage outboundRealTimeMessage = OutboundRealTimeMessage.this;
                                    synchronized (outboundRealTimeMessage) {
                                        if (System.currentTimeMillis() - OutboundRealTimeMessage.this.lastTextChange < refreshInterval) {
                                            OutboundRealTimeMessage.this.reset();
                                        }
                                        OutboundRealTimeMessage.this.nextRefresh = OutboundRealTimeMessage.this.refreshExecutor.schedule(this, refreshInterval, TimeUnit.MILLISECONDS);
                                    }
                                }
                            }, refreshInterval, TimeUnit.MILLISECONDS);
                        }
                        OutboundRealTimeMessage.this.sendRttMessage(OutboundRealTimeMessage.this.isNew ? RealTimeText.Event.NEW : RealTimeText.Event.EDIT);
                        OutboundRealTimeMessage.this.isNew = false;
                    }
                    OutboundRealTimeMessage.this.nextTransmission = OutboundRealTimeMessage.this.transmissionExecutor.schedule(this, transmissionInterval, TimeUnit.MILLISECONDS);
                }
            }
        }, transmissionInterval, TimeUnit.MILLISECONDS);
    }

    static int generateSequenceNumber() {
        return RANDOM.nextInt(100000);
    }

    static List<RealTimeText.Action> computeActionElements(String oldText, String newText) {
        if (oldText == null && newText == null || oldText != null && oldText.equals(newText) || oldText == null && newText.isEmpty() || newText == null && oldText.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RealTimeText.Action> actions = new ArrayList<RealTimeText.Action>();
        if (oldText == null) {
            actions.add((RealTimeText.Action)new RealTimeText.InsertText(newText));
        } else if (newText == null) {
            actions.add((RealTimeText.Action)new RealTimeText.EraseText(Integer.valueOf(oldText.length()), Integer.valueOf(oldText.length())));
        } else {
            int endIndex;
            int firstChangedCharacter;
            int[] bounds = OutboundRealTimeMessage.determineBounds(oldText, newText);
            int lastChangedCharacter = bounds[1];
            int n = lastChangedCharacter - (firstChangedCharacter = bounds[0]);
            if (n > 0) {
                actions.add((RealTimeText.Action)new RealTimeText.EraseText(n == 1 ? null : Integer.valueOf(n), lastChangedCharacter == oldText.length() ? null : Integer.valueOf(lastChangedCharacter)));
            }
            if ((endIndex = newText.length() - oldText.length() + lastChangedCharacter) > firstChangedCharacter) {
                actions.add((RealTimeText.Action)new RealTimeText.InsertText(newText.substring(firstChangedCharacter, endIndex), firstChangedCharacter == oldText.length() ? null : Integer.valueOf(firstChangedCharacter)));
            }
        }
        return actions;
    }

    static int[] determineBounds(String oldText, String newText) {
        int lastChangedCharacter;
        int firstChangedCharacter;
        for (firstChangedCharacter = 0; firstChangedCharacter < oldText.length() && firstChangedCharacter < newText.length() && oldText.charAt(firstChangedCharacter) == newText.charAt(firstChangedCharacter); ++firstChangedCharacter) {
        }
        for (lastChangedCharacter = 0; lastChangedCharacter < oldText.length() && lastChangedCharacter < newText.length() && firstChangedCharacter < newText.length() && firstChangedCharacter < oldText.length() - lastChangedCharacter && firstChangedCharacter < newText.length() - lastChangedCharacter && oldText.charAt(oldText.length() - 1 - lastChangedCharacter) == newText.charAt(newText.length() - 1 - lastChangedCharacter); ++lastChangedCharacter) {
        }
        return new int[]{firstChangedCharacter, oldText.length() - lastChangedCharacter};
    }

    public final synchronized void update(String text) {
        if (this.complete) {
            throw new IllegalStateException("Real-time message is already completed.");
        }
        long now = System.currentTimeMillis();
        if (!this.actions.isEmpty() && now != this.lastTextChange) {
            this.actions.add((RealTimeText.Action)new RealTimeText.WaitInterval(now - this.lastTextChange));
        }
        this.lastTextChange = now;
        text = Normalizer.normalize(text, Normalizer.Form.NFC).replace("\r\n", "\n");
        this.actions.addAll(OutboundRealTimeMessage.computeActionElements(this.text, text));
        this.text = text;
    }

    public final synchronized void reset() {
        this.reset(null, this.text);
    }

    public final synchronized void reset(String id, String text) {
        this.id = id;
        this.text = text;
        this.sequence = OutboundRealTimeMessage.generateSequenceNumber();
        this.actions.clear();
        this.actions.add((RealTimeText.Action)new RealTimeText.InsertText(text));
        this.sendRttMessage(RealTimeText.Event.RESET);
    }

    @Override
    public final synchronized String getText() {
        return this.text != null ? this.text : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message commit() {
        if (this.complete) {
            throw new IllegalStateException("Already committed.");
        }
        Message message = this.chat.sendMessage(this.getText());
        this.complete = true;
        OutboundRealTimeMessage outboundRealTimeMessage = this;
        synchronized (outboundRealTimeMessage) {
            if (this.nextRefresh != null) {
                this.nextRefresh.cancel(false);
            }
            if (this.nextTransmission != null) {
                this.nextTransmission.cancel(false);
            }
        }
        this.refreshExecutor.shutdown();
        this.transmissionExecutor.shutdown();
        return message;
    }

    private void sendRttMessage(RealTimeText.Event event) {
        Message message = new Message();
        RealTimeText realTimeText = new RealTimeText(event, this.actions, this.sequence++, this.id);
        message.addExtension((Object)realTimeText);
        this.chat.sendMessage(message);
        this.actions.clear();
    }

    public final long getRefreshInterval() {
        return this.refreshInterval;
    }

    public final long getTransmissionInterval() {
        return this.transmissionInterval;
    }
}

