/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.transports.s5b;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHost;
import rocks.xmpp.extensions.jingle.JingleSession;
import rocks.xmpp.extensions.jingle.transports.TransportNegotiator;
import rocks.xmpp.extensions.jingle.transports.s5b.model.S5bTransportMethod;

public final class S5bTransportNegotiator
extends TransportNegotiator<S5bTransportMethod> {
    private final Socks5ByteStreamManager socks5ByteStreamManager;
    private final XmppSession xmppSession;

    protected S5bTransportNegotiator(JingleSession jingleSession, XmppSession xmppSession) {
        super(jingleSession);
        this.xmppSession = xmppSession;
        this.socks5ByteStreamManager = (Socks5ByteStreamManager)xmppSession.getManager(Socks5ByteStreamManager.class);
    }

    private S5bTransportMethod createTransport() throws IOException {
        S5bTransportMethod s5bTransportMethod = new S5bTransportMethod();
        List<StreamHost> streamHosts = this.socks5ByteStreamManager.getAvailableStreamHosts();
        for (StreamHost streamHost : streamHosts) {
            s5bTransportMethod.getCandidates().add(new S5bTransportMethod.Candidate(UUID.randomUUID().toString(), streamHost.getHost(), streamHost.getJid(), 0, streamHost.getJid().equals((Object)this.xmppSession.getConnectedResource()) ? S5bTransportMethod.Candidate.Type.DIRECT : S5bTransportMethod.Candidate.Type.PROXY, streamHost.getPort()));
        }
        return s5bTransportMethod;
    }
}

