/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.langtrans;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.langtrans.model.LanguageTranslation;
import rocks.xmpp.extensions.langtrans.model.items.LanguageSupport;

public final class LanguageTranslationManager
extends Manager {
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    private LanguageTranslationManager(XmppSession xmppSession) {
        super(xmppSession);
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    public Collection<Item> discoverTranslationProviders() throws XmppException {
        return this.serviceDiscoveryManager.discoverServices(Identity.automationTranslation());
    }

    public List<LanguageSupport.Item> discoverLanguageSupport(Jid translationProvider) throws XmppException {
        return ((LanguageSupport)this.xmppSession.query(IQ.get((Jid)translationProvider, (Object)new LanguageSupport())).getExtension(LanguageSupport.class)).getItems();
    }

    public List<LanguageTranslation.Translation> translate(Jid translationProvider, String text, String sourceLanguage, String ... destinationLanguage) throws XmppException {
        ArrayDeque<LanguageTranslation.Translation> translations = new ArrayDeque<LanguageTranslation.Translation>();
        for (String dl : destinationLanguage) {
            translations.add(LanguageTranslation.Translation.ofDestinationLanguage((String)dl));
        }
        IQ result = this.xmppSession.query(IQ.get((Jid)translationProvider, (Object)new LanguageTranslation(text, sourceLanguage, translations)));
        LanguageTranslation languageTranslation = (LanguageTranslation)result.getExtension(LanguageTranslation.class);
        return languageTranslation != null ? languageTranslation.getTranslations() : Collections.emptyList();
    }
}

