/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.reach;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.extensions.reach.ReachabilityEvent;
import rocks.xmpp.extensions.reach.model.Address;
import rocks.xmpp.extensions.reach.model.Reachability;
import rocks.xmpp.util.XmppUtils;

public final class ReachabilityManager
extends Manager {
    private final Set<Consumer<ReachabilityEvent>> reachabilityListeners = new CopyOnWriteArraySet<Consumer<ReachabilityEvent>>();
    private final Map<Jid, List<Address>> reachabilities = new ConcurrentHashMap<Jid, List<Address>>();
    private final List<Address> addresses = new CopyOnWriteArrayList<Address>();
    private final Consumer<PresenceEvent> inboundPresenceListener = e -> {
        Presence presence = e.getPresence();
        boolean hasReachability = this.checkStanzaForReachabilityAndNotify((Stanza)presence);
        Jid contact = presence.getFrom().asBareJid();
        if (!hasReachability && this.reachabilities.remove(contact) != null) {
            XmppUtils.notifyEventListeners(this.reachabilityListeners, (EventObject)new ReachabilityEvent((Object)this, contact, Collections.emptyList()));
        }
    };
    private final Consumer<PresenceEvent> outboundPresenceListener = e -> {
        Presence presence = e.getPresence();
        if (presence.isAvailable() && presence.getTo() == null) {
            List<Address> list = this.addresses;
            synchronized (list) {
                if (!this.addresses.isEmpty()) {
                    presence.addExtension((Object)new Reachability(new ArrayDeque<Address>(this.addresses)));
                }
            }
        }
    };
    private final Consumer<MessageEvent> inboundMessageEvent = e -> this.checkStanzaForReachabilityAndNotify((Stanza)e.getMessage());
    private final IQHandler iqHandler = new AbstractIQHandler(IQ.Type.GET){

        protected IQ processRequest(IQ iq) {
            return iq.createResult((Object)new Reachability((Collection)ReachabilityManager.this.addresses));
        }
    };

    private ReachabilityManager(XmppSession xmppSession) {
        super(xmppSession, true);
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.addOutboundPresenceListener(this.outboundPresenceListener);
        this.xmppSession.addInboundMessageListener(this.inboundMessageEvent);
        this.xmppSession.addIQHandler(Reachability.class, this.iqHandler);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.removeOutboundPresenceListener(this.outboundPresenceListener);
        this.xmppSession.removeInboundMessageListener(this.inboundMessageEvent);
        this.xmppSession.removeIQHandler(Reachability.class);
    }

    public List<Address> getReachabilityAddresses() {
        return this.addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStanzaForReachabilityAndNotify(Stanza stanza) {
        Reachability reachability = (Reachability)stanza.getExtension(Reachability.class);
        if (stanza.getFrom() != null) {
            Jid contact = stanza.getFrom().asBareJid();
            if (reachability != null) {
                Map<Jid, List<Address>> map = this.reachabilities;
                synchronized (map) {
                    List<Address> oldReachabilityAddresses = this.reachabilities.get(contact);
                    if (oldReachabilityAddresses == null || !oldReachabilityAddresses.equals(reachability.getAddresses())) {
                        this.reachabilities.put(contact, reachability.getAddresses());
                        XmppUtils.notifyEventListeners(this.reachabilityListeners, (EventObject)new ReachabilityEvent((Object)this, contact, reachability.getAddresses()));
                    }
                }
            }
        }
        return reachability != null;
    }

    public void addReachabilityListener(Consumer<ReachabilityEvent> reachabilityListener) {
        this.reachabilityListeners.add(reachabilityListener);
    }

    public void removeReachabilityListener(Consumer<ReachabilityEvent> reachabilityListener) {
        this.reachabilityListeners.remove(reachabilityListener);
    }

    public List<Address> requestReachabilityAddresses(Jid contact) throws XmppException {
        IQ result = this.xmppSession.query(IQ.get((Jid)contact, (Object)new Reachability()));
        Reachability reachability = (Reachability)result.getExtension(Reachability.class);
        if (reachability != null) {
            return reachability.getAddresses();
        }
        return null;
    }

    protected void dispose() {
        this.reachabilityListeners.clear();
        this.reachabilities.clear();
        this.addresses.clear();
    }
}

