/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rtt;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.rtt.RealTimeMessage;
import rocks.xmpp.extensions.rtt.RealTimeTextChangeEvent;
import rocks.xmpp.extensions.rtt.model.RealTimeText;
import rocks.xmpp.util.XmppUtils;

public final class InboundRealTimeMessage
extends RealTimeMessage {
    private final StringBuilder sb;
    private final ExecutorService processActionsExecutor;
    private final Queue<RealTimeText.Action> actions = new LinkedList<RealTimeText.Action>();
    private final Jid from;
    private final Set<Consumer<RealTimeTextChangeEvent>> textChangeListeners = new CopyOnWriteArraySet<Consumer<RealTimeTextChangeEvent>>();

    InboundRealTimeMessage(Jid contact, int sequence, String id) {
        this.from = contact;
        this.sequence = sequence;
        this.sb = new StringBuilder();
        this.id = id;
        this.processActionsExecutor = Executors.newSingleThreadExecutor(XmppUtils.createNamedThreadFactory((String)"Real-time Text Processing Thread"));
        this.processActionsExecutor.execute(() -> {
            while (!this.complete) {
                try {
                    Queue<RealTimeText.Action> queue = this.actions;
                    synchronized (queue) {
                        while (!this.actions.isEmpty()) {
                            RealTimeText.Action action = this.actions.poll();
                            if (action instanceof RealTimeText.WaitInterval) {
                                Long ms = ((RealTimeText.WaitInterval)action).getMilliSeconds();
                                if (ms == null) continue;
                                this.actions.wait(ms);
                                continue;
                            }
                            this.applyActionElement(action);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void processActions(List<RealTimeText.Action> actions, boolean incrementSequence) {
        if (this.isComplete()) {
            throw new IllegalStateException("Real-time message is already completed.");
        }
        if (incrementSequence) {
            ++this.sequence;
        }
        Queue<RealTimeText.Action> queue = this.actions;
        synchronized (queue) {
            this.actions.addAll(actions);
            this.actions.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyActionElement(RealTimeText.Action action) {
        String s;
        InboundRealTimeMessage inboundRealTimeMessage = this;
        synchronized (inboundRealTimeMessage) {
            if (action instanceof RealTimeText.InsertText) {
                RealTimeText.InsertText insertText = (RealTimeText.InsertText)action;
                if (insertText.getText() != null) {
                    this.sb.insert(this.normalizePosition(insertText.getPosition()), insertText.getText());
                }
            } else if (action instanceof RealTimeText.EraseText) {
                RealTimeText.EraseText eraseText = (RealTimeText.EraseText)action;
                Integer pos = this.normalizePosition(eraseText.getPosition());
                Integer n = eraseText.getNumberOfCharacters();
                if (n == null) {
                    n = 1;
                }
                if (n < 0) {
                    n = 0;
                }
                if (pos >= n && pos - n <= this.sb.length()) {
                    this.sb.delete(pos - n, pos);
                }
            }
            s = this.sb.toString();
        }
        XmppUtils.notifyEventListeners(this.textChangeListeners, (EventObject)new RealTimeTextChangeEvent(this, s));
    }

    private int normalizePosition(Integer pos) {
        if (pos == null) {
            pos = this.sb.length();
        }
        if (pos < 0) {
            pos = 0;
        }
        if (pos > this.sb.length()) {
            pos = this.sb.length();
        }
        return pos;
    }

    synchronized void reset(int sequence, String id) {
        this.sequence = sequence;
        this.sb.setLength(0);
        this.id = id;
        this.actions.clear();
    }

    synchronized void complete() {
        if (!this.complete) {
            this.complete = true;
            this.processActionsExecutor.shutdown();
            this.textChangeListeners.clear();
        }
    }

    @Override
    public final synchronized String getText() {
        return this.sb.toString();
    }

    public final Jid getFrom() {
        return this.from;
    }

    public final void addRealTimeTextChangeListener(Consumer<RealTimeTextChangeEvent> realTimeTextListener) {
        this.textChangeListeners.add(realTimeTextListener);
    }

    public final void removeRealTimeTextChangeListener(Consumer<RealTimeTextChangeEvent> realTimeTextListener) {
        this.textChangeListeners.remove(realTimeTextListener);
    }
}

