/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.component.accept;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.component.accept.model.ComponentIQ;
import rocks.xmpp.extensions.component.accept.model.ComponentMessage;
import rocks.xmpp.extensions.component.accept.model.ComponentPresence;
import rocks.xmpp.extensions.component.accept.model.Handshake;

public final class ExternalComponent
extends XmppSession {
    private static final Logger logger = Logger.getLogger(ExternalComponent.class.getName());
    private final Lock lock = new ReentrantLock();
    private final Condition streamOpened = this.lock.newCondition();
    private final Condition handshakeReceived = this.lock.newCondition();
    private final String sharedSecret;
    private volatile Jid connectedResource;
    private volatile boolean streamHeaderReceived;

    public ExternalComponent(String componentName, String sharedSecret, String hostname, int port) {
        this(componentName, sharedSecret, XmppSessionConfiguration.getDefault(), hostname, port);
    }

    public ExternalComponent(String componentName, String sharedSecret, XmppSessionConfiguration configuration, String hostname, int port) {
        super(componentName, configuration, new ConnectionConfiguration[]{((TcpConnectionConfiguration.Builder)((TcpConnectionConfiguration.Builder)TcpConnectionConfiguration.builder().hostname(hostname)).port(port)).build()});
        this.sharedSecret = sharedSecret;
    }

    public final void connect(Jid from) throws XmppException {
        XmppSession.Status previousStatus = this.getStatus();
        if (previousStatus == XmppSession.Status.CLOSED) {
            throw new IllegalStateException("Session is already closed. Create a new one.");
        }
        if (this.isConnected() || !this.updateStatus(XmppSession.Status.CONNECTING)) {
            logger.fine("Already connected. Return silently.");
            return;
        }
        this.exception = null;
        this.streamHeaderReceived = false;
        try {
            this.tryConnect(from, "jabber:component:accept", this::onStreamOpened);
            logger.fine("Negotiating stream, waiting until handshake is ready to be negotiated.");
            this.lock.lock();
            try {
                if (!this.streamHeaderReceived) {
                    this.streamOpened.await(this.configuration.getDefaultResponseTimeout(), TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this.lock.unlock();
            }
            Thread.sleep(20L);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)this.exception);
            this.connectedResource = this.getDomain();
            this.updateStatus(XmppSession.Status.CONNECTED);
            this.login(this.sharedSecret);
        }
        catch (Throwable e) {
            this.onConnectionFailed(previousStatus, e);
        }
    }

    private void login(String sharedSecret) throws XmppException {
        XmppSession.Status previousStatus = this.preLogin();
        try {
            this.send((StreamElement)Handshake.create((String)this.activeConnection.getStreamId(), (String)sharedSecret));
            this.lock.lock();
            try {
                this.handshakeReceived.await(this.configuration.getDefaultResponseTimeout(), TimeUnit.MILLISECONDS);
            }
            finally {
                this.lock.unlock();
            }
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)this.exception);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.updateStatus(previousStatus, e);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)e);
        }
        catch (Throwable e) {
            this.updateStatus(previousStatus, e);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)e);
        }
        this.updateStatus(XmppSession.Status.AUTHENTICATED);
    }

    public final boolean handleElement(Object element) throws XmppException {
        if (element instanceof Handshake) {
            this.releaseLock();
        } else {
            super.handleElement(element);
        }
        return false;
    }

    public final void notifyException(Throwable e) {
        super.notifyException(e);
        this.releaseLock();
    }

    private void releaseLock() {
        this.lock.lock();
        try {
            this.handshakeReceived.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onStreamOpened(Jid domain) {
        this.setXmppServiceDomain(domain);
        this.streamHeaderReceived = true;
        this.lock.lock();
        try {
            this.streamOpened.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public final Jid getConnectedResource() {
        return this.connectedResource;
    }

    public final StreamElement send(StreamElement element) {
        if (element instanceof Stanza && ((Stanza)element).getFrom() == null) {
            ((Stanza)element).setFrom(this.connectedResource);
        }
        if (element instanceof Message) {
            element = ComponentMessage.from((Message)((Message)element));
        } else if (element instanceof Presence) {
            element = ComponentPresence.from((Presence)((Presence)element));
        } else if (element instanceof IQ) {
            element = ComponentIQ.from((IQ)((IQ)element));
        }
        super.send(element);
        return element;
    }
}

