/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.ArrayList;
import java.util.List;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.muc.ChatRoom;
import rocks.xmpp.extensions.muc.MultiUserChatManager;

public final class ChatService
implements Comparable<ChatService> {
    private final XmppSession xmppSession;
    private final Jid serviceAddress;
    private final String name;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final MultiUserChatManager multiUserChatManager;

    ChatService(Jid serviceAddress, String name, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager, MultiUserChatManager multiUserChatManager) {
        this.xmppSession = xmppSession;
        this.serviceAddress = serviceAddress;
        this.name = name;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.multiUserChatManager = multiUserChatManager;
    }

    public List<ChatRoom> discoverRooms() throws XmppException {
        ArrayList<ChatRoom> chatRooms = new ArrayList<ChatRoom>();
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.serviceAddress);
        for (Item item : itemNode.getItems()) {
            ChatRoom chatRoom = new ChatRoom(item.getJid(), item.getName(), this.xmppSession, this.serviceDiscoveryManager, this.multiUserChatManager);
            chatRoom.initialize();
            chatRooms.add(chatRoom);
        }
        return chatRooms;
    }

    public ChatRoom createRoom(String room) {
        ChatRoom chatRoom = new ChatRoom(this.serviceAddress.withLocal((CharSequence)room), null, this.xmppSession, this.serviceDiscoveryManager, this.multiUserChatManager);
        chatRoom.initialize();
        return chatRoom;
    }

    public Jid getAddress() {
        return this.serviceAddress;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.serviceAddress != null ? this.serviceAddress.toString() : super.toString();
    }

    @Override
    public int compareTo(ChatService o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result;
            if (this.name != null) {
                result = o.name != null ? this.name.compareTo(o.name) : -1;
            } else {
                int n = result = o.name != null ? 1 : 0;
            }
            if (result == 0) {
                if (this.serviceAddress != null) {
                    return o.serviceAddress != null ? this.serviceAddress.compareTo(o.serviceAddress) : -1;
                }
                return o.serviceAddress != null ? 1 : 0;
            }
            return result;
        }
        return -1;
    }
}

