/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamEvent;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.s5b.S5bSession;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.s5b.model.Socks5ByteStream;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHost;
import rocks.xmpp.util.concurrent.AsyncResult;

final class S5bEvent
extends ByteStreamEvent {
    private final XmppSession xmppSession;
    private final IQ iq;
    private final List<StreamHost> streamHosts;

    public S5bEvent(Object source, String sessionId, XmppSession xmppSession, IQ iq, List<StreamHost> streamHosts) {
        super(source, sessionId);
        this.xmppSession = xmppSession;
        this.iq = iq;
        this.streamHosts = streamHosts;
    }

    @Override
    public final AsyncResult<ByteStreamSession> accept() {
        CompletableFuture<ByteStreamSession> completableFuture = CompletableFuture.supplyAsync(() -> {
            try {
                S5bSession s5bSession = Socks5ByteStreamManager.createS5bSession(this.iq.getFrom(), this.iq.getTo(), this.getSessionId(), this.streamHosts);
                this.xmppSession.send((StreamElement)this.iq.createResult((Object)Socks5ByteStream.streamHostUsed((String)s5bSession.getSessionId(), (Jid)s5bSession.getStreamHost())));
                return s5bSession;
            }
            catch (IOException e) {
                this.xmppSession.send((StreamElement)this.iq.createError(Condition.ITEM_NOT_FOUND));
                throw new CompletionException(e);
            }
        });
        return new AsyncResult(completableFuture);
    }

    @Override
    public final void reject() {
        this.xmppSession.send((StreamElement)this.iq.createError(Condition.NOT_ACCEPTABLE));
    }
}

