/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.muc.model.MucFeature;
import rocks.xmpp.extensions.muc.model.RoomInfo;

public final class RoomInformation {
    private final Identity identity;
    private final Set<MucFeature> features;
    private final RoomInfo roomInfo;

    RoomInformation(Identity identity, Set<MucFeature> features, RoomInfo roomInfo) {
        this.identity = identity;
        this.features = features;
        this.roomInfo = roomInfo;
    }

    public String getName() {
        return this.identity != null ? this.identity.getName() : null;
    }

    public int getMaxHistoryMessages() {
        if (this.roomInfo != null) {
            return this.roomInfo.getMaxHistoryMessages();
        }
        return 0;
    }

    public List<Jid> getContacts() {
        if (this.roomInfo != null) {
            return this.roomInfo.getContacts();
        }
        return Collections.emptyList();
    }

    public String getDescription() {
        if (this.roomInfo != null) {
            return this.roomInfo.getDescription();
        }
        return null;
    }

    public Locale getLanguage() {
        if (this.roomInfo != null) {
            return this.roomInfo.getLanguage();
        }
        return null;
    }

    public String getLdapGroup() {
        if (this.roomInfo != null) {
            return this.roomInfo.getLdapGroup();
        }
        return null;
    }

    public URL getLogs() {
        if (this.roomInfo != null) {
            return this.roomInfo.getLogs();
        }
        return null;
    }

    public Integer getCurrentNumberOfOccupants() {
        if (this.roomInfo != null) {
            return this.roomInfo.getCurrentNumberOfOccupants();
        }
        return null;
    }

    public String getSubject() {
        if (this.roomInfo != null) {
            return this.roomInfo.getSubject();
        }
        return null;
    }

    public boolean isChangeSubjectAllowed() {
        return this.roomInfo != null && this.roomInfo.isChangeSubjectAllowed();
    }

    public boolean isHidden() {
        return this.features.contains(MucFeature.HIDDEN);
    }

    public boolean isMembersOnly() {
        return this.features.contains(MucFeature.MEMBERS_ONLY);
    }

    public boolean isModerated() {
        return this.features.contains(MucFeature.MODERATED);
    }

    public boolean isNonAnonymous() {
        return this.features.contains(MucFeature.NON_ANONYMOUS);
    }

    public boolean isOpen() {
        return this.features.contains(MucFeature.OPEN);
    }

    public boolean isPasswordProtected() {
        return this.features.contains(MucFeature.PASSWORD_PROTECTED);
    }

    public boolean isPersistent() {
        return this.features.contains(MucFeature.PERSISTENT);
    }

    public boolean isPublic() {
        return this.features.contains(MucFeature.PUBLIC);
    }

    public boolean isSemiAnonymous() {
        return this.features.contains(MucFeature.SEMI_ANONYMOUS);
    }

    public boolean isTemporary() {
        return this.features.contains(MucFeature.TEMPORARY);
    }

    public boolean isUnmoderated() {
        return this.features.contains(MucFeature.UNMODERATED);
    }

    public boolean isUnsecured() {
        return this.features.contains(MucFeature.UNSECURED);
    }
}

