/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rosterx;

import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.logging.Logger;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.rosterx.ContactExchangeEvent;
import rocks.xmpp.extensions.rosterx.model.ContactExchange;
import rocks.xmpp.im.roster.RosterManager;
import rocks.xmpp.im.roster.model.Contact;
import rocks.xmpp.im.subscription.PresenceManager;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ContactExchangeManager
extends Manager {
    private static final Logger logger = Logger.getLogger(ContactExchangeManager.class.getName());
    private final Set<Consumer<ContactExchangeEvent>> contactExchangeListeners = new CopyOnWriteArraySet<Consumer<ContactExchangeEvent>>();
    private final Collection<Jid> trustedEntities = new CopyOnWriteArraySet<Jid>();
    private final Consumer<MessageEvent> inboundMessageListener = e -> {
        List<ContactExchange.Item> items;
        Message message = e.getMessage();
        ContactExchange contactExchange = (ContactExchange)message.getExtension(ContactExchange.class);
        if (contactExchange != null && !(items = this.getItemsToProcess(contactExchange.getItems())).isEmpty()) {
            this.processItems(items, message.getFrom(), message.getBody(), DelayedDelivery.sendDate((Stanza)message));
        }
    };
    private final IQHandler iqHandler;

    private ContactExchangeManager(final XmppSession xmppSession) {
        super(xmppSession);
        this.iqHandler = new AbstractIQHandler(IQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                ContactExchange contactExchange = (ContactExchange)iq.getExtension(ContactExchange.class);
                if (((RosterManager)xmppSession.getManager(RosterManager.class)).getContact(iq.getFrom().asBareJid()) == null) {
                    return iq.createError(Condition.NOT_AUTHORIZED);
                }
                List<ContactExchange.Item> items = ContactExchangeManager.this.getItemsToProcess(contactExchange.getItems());
                if (!items.isEmpty()) {
                    ContactExchangeManager.this.processItems(items, iq.getFrom(), null, Instant.now());
                }
                return iq.createResult();
            }
        };
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundMessageListener(this.inboundMessageListener);
        this.xmppSession.addIQHandler(ContactExchange.class, this.iqHandler);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundMessageListener(this.inboundMessageListener);
        this.xmppSession.removeIQHandler(ContactExchange.class);
    }

    private void processItems(List<ContactExchange.Item> items, Jid sender, String message, Instant date) {
        if (this.getTrustedEntities().contains(sender.asBareJid())) {
            for (ContactExchange.Item item : items) {
                this.approve(item);
            }
        } else {
            XmppUtils.notifyEventListeners(this.contactExchangeListeners, (EventObject)new ContactExchangeEvent((Object)this, items, sender, message, date));
        }
    }

    List<ContactExchange.Item> getItemsToProcess(Collection<ContactExchange.Item> items) {
        ArrayList<ContactExchange.Item> newItems = new ArrayList<ContactExchange.Item>();
        for (ContactExchange.Item item : items) {
            ArrayDeque specifiedGroups;
            Contact contact = ((RosterManager)this.xmppSession.getManager(RosterManager.class)).getContact(item.getJid());
            if (item.getAction() == null || item.getAction() == ContactExchange.Item.Action.ADD) {
                if (contact != null) {
                    specifiedGroups = new ArrayDeque(item.getGroups());
                    specifiedGroups.removeAll(contact.getGroups());
                    if (specifiedGroups.isEmpty()) continue;
                    newItems.add(new ContactExchange.Item(item.getJid(), item.getName(), specifiedGroups, ContactExchange.Item.Action.ADD));
                    continue;
                }
                newItems.add(item);
                continue;
            }
            if (item.getAction() == ContactExchange.Item.Action.DELETE) {
                if (contact == null) continue;
                specifiedGroups = new ArrayDeque(item.getGroups());
                specifiedGroups.retainAll(contact.getGroups());
                if (specifiedGroups.isEmpty() && !contact.getGroups().isEmpty()) continue;
                newItems.add(new ContactExchange.Item(item.getJid(), item.getName(), specifiedGroups, ContactExchange.Item.Action.DELETE));
                continue;
            }
            if (item.getAction() != ContactExchange.Item.Action.MODIFY || contact == null) continue;
            newItems.add(item);
        }
        return newItems;
    }

    public final Collection<Jid> getTrustedEntities() {
        return this.trustedEntities;
    }

    public AsyncResult<Void> suggestContactAddition(Jid jid, Contact ... contacts) {
        if (contacts.length > 0) {
            ArrayDeque<ContactExchange.Item> rosterItems = new ArrayDeque<ContactExchange.Item>();
            for (Contact contact : contacts) {
                if (contact.getJid() == null) {
                    throw new IllegalArgumentException("Contact contains no JID.");
                }
                rosterItems.add(new ContactExchange.Item(contact.getJid(), contact.getName(), (Collection)contact.getGroups(), ContactExchange.Item.Action.ADD));
            }
            ContactExchange contactExchange = new ContactExchange(rosterItems);
            Presence presence = ((PresenceManager)this.xmppSession.getManager(PresenceManager.class)).getPresence(jid);
            if (presence.isAvailable()) {
                return this.xmppSession.query(IQ.set((Jid)presence.getFrom(), (Object)contactExchange), Void.class);
            }
            Message message = new Message(jid, Message.Type.NORMAL);
            message.addExtension((Object)contactExchange);
            this.xmppSession.send((StreamElement)message);
        }
        return new AsyncResult(CompletableFuture.completedFuture(null));
    }

    public ContactExchange.Item.Action approve(ContactExchange.Item item) {
        RosterManager rosterManager = (RosterManager)this.xmppSession.getManager(RosterManager.class);
        Contact contact = rosterManager.getContact(item.getJid());
        ContactExchange.Item.Action action = null;
        if (item.getAction() == null || item.getAction() == ContactExchange.Item.Action.ADD) {
            if (contact == null) {
                rosterManager.addContact(new Contact(item.getJid(), item.getName(), (Collection)item.getGroups()), true, null);
                action = ContactExchange.Item.Action.ADD;
            } else {
                ArrayDeque newGroups = new ArrayDeque(contact.getGroups());
                ArrayDeque additionalGroups = new ArrayDeque(item.getGroups());
                additionalGroups.removeAll(newGroups);
                if (!additionalGroups.isEmpty()) {
                    newGroups.addAll(additionalGroups);
                    rosterManager.updateContact(new Contact(contact.getJid(), contact.getName(), newGroups));
                    action = ContactExchange.Item.Action.MODIFY;
                }
            }
        } else if (item.getAction() == ContactExchange.Item.Action.DELETE) {
            if (contact != null) {
                ArrayDeque existingGroups = new ArrayDeque(contact.getGroups());
                ArrayDeque specifiedGroups = new ArrayDeque(item.getGroups());
                existingGroups.removeAll(specifiedGroups);
                if (!existingGroups.isEmpty()) {
                    rosterManager.updateContact(new Contact(contact.getJid(), contact.getName(), existingGroups));
                    action = ContactExchange.Item.Action.MODIFY;
                } else {
                    rosterManager.removeContact(item.getJid());
                    action = ContactExchange.Item.Action.DELETE;
                }
            }
        } else if (item.getAction() == ContactExchange.Item.Action.MODIFY && contact != null) {
            rosterManager.updateContact(new Contact(item.getJid(), item.getName(), (Collection)item.getGroups()));
            action = ContactExchange.Item.Action.MODIFY;
        }
        return action;
    }

    public void addContactExchangeListener(Consumer<ContactExchangeEvent> contactExchangeListener) {
        this.contactExchangeListeners.add(contactExchangeListener);
    }

    public void removeContactExchangeListener(Consumer<ContactExchangeEvent> contactExchangeListener) {
        this.contactExchangeListeners.remove(contactExchangeListener);
    }

    protected void dispose() {
        this.contactExchangeListeners.clear();
        this.trustedEntities.clear();
    }
}

