/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.si;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamEvent;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.InBandByteStreamManager;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5ByteStreamManager;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.featureneg.model.FeatureNegotiation;
import rocks.xmpp.extensions.filetransfer.FileTransfer;
import rocks.xmpp.extensions.filetransfer.FileTransferManager;
import rocks.xmpp.extensions.filetransfer.FileTransferNegotiator;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.si.model.StreamInitiation;
import rocks.xmpp.extensions.si.profile.filetransfer.model.SIFileTransferOffer;
import rocks.xmpp.util.concurrent.AsyncResult;
import rocks.xmpp.util.concurrent.CompletionStages;

public final class StreamInitiationManager
extends Manager
implements FileTransferNegotiator {
    private static final Logger logger = Logger.getLogger(StreamInitiationManager.class.getName());
    private static final String STREAM_METHOD = "stream-method";
    private final Map<String, ProfileManager> profileManagers = new ConcurrentHashMap<String, ProfileManager>();
    private final InBandByteStreamManager inBandByteStreamManager;
    private final Socks5ByteStreamManager socks5ByteStreamManager;
    private final IQHandler iqHandler;

    private StreamInitiationManager(XmppSession xmppSession) {
        super(xmppSession);
        this.inBandByteStreamManager = (InBandByteStreamManager)xmppSession.getManager(InBandByteStreamManager.class);
        this.socks5ByteStreamManager = (Socks5ByteStreamManager)xmppSession.getManager(Socks5ByteStreamManager.class);
        this.profileManagers.put("http://jabber.org/protocol/si/profile/file-transfer", (iq, streamInitiation) -> {
            FileTransferManager fileTransferManager = (FileTransferManager)xmppSession.getManager(FileTransferManager.class);
            fileTransferManager.fileTransferOffered(iq, streamInitiation.getId(), streamInitiation.getMimeType(), (FileTransferOffer)streamInitiation.getProfileElement(), streamInitiation, this);
        });
        this.iqHandler = new AbstractIQHandler(IQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                List streamMethods;
                DataForm.Field field;
                DataForm dataForm;
                StreamInitiation streamInitiation = (StreamInitiation)iq.getExtension(StreamInitiation.class);
                FeatureNegotiation featureNegotiation = streamInitiation.getFeatureNegotiation();
                boolean noValidStreams = true;
                if (featureNegotiation != null && (dataForm = featureNegotiation.getDataForm()) != null && (field = dataForm.findField(StreamInitiationManager.STREAM_METHOD)) != null && !Collections.disjoint(streamMethods = field.getOptions().stream().map(DataForm.Option::getValue).collect(Collectors.toList()), StreamInitiationManager.this.getSupportedStreamMethods())) {
                    noValidStreams = false;
                }
                if (noValidStreams) {
                    return iq.createError(new StanzaError(Condition.BAD_REQUEST, StreamInitiation.NO_VALID_STREAMS));
                }
                ProfileManager profileManager = (ProfileManager)StreamInitiationManager.this.profileManagers.get(streamInitiation.getProfile());
                if (profileManager == null) {
                    return iq.createError(new StanzaError(Condition.BAD_REQUEST, StreamInitiation.BAD_PROFILE));
                }
                profileManager.handle(iq, streamInitiation);
                return null;
            }
        };
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(StreamInitiation.class, this.iqHandler);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(StreamInitiation.class);
    }

    public AsyncResult<OutputStream> initiateStream(Jid receiver, SIFileTransferOffer profile, String mimeType, long timeout) {
        String sessionId = UUID.randomUUID().toString();
        List options = this.getSupportedStreamMethods().stream().map(DataForm.Option::new).collect(Collectors.toList());
        DataForm.Field field = DataForm.Field.builder().var(STREAM_METHOD).type(DataForm.Field.Type.LIST_SINGLE).options(options).build();
        DataForm dataForm = new DataForm(DataForm.Type.FORM, Collections.singleton(field));
        return this.xmppSession.query(IQ.set((Jid)receiver, (Object)new StreamInitiation(sessionId, "http://jabber.org/protocol/si/profile/file-transfer", mimeType, (Object)profile, new FeatureNegotiation(dataForm))), timeout).thenCompose(result -> {
            Object byteStreamSessionStage;
            String streamMethod;
            StreamInitiation streamInitiation = (StreamInitiation)result.getExtension(StreamInitiation.class);
            FeatureNegotiation featureNegotiation = streamInitiation.getFeatureNegotiation();
            switch (streamMethod = (String)featureNegotiation.getDataForm().findField(STREAM_METHOD).getValues().get(0)) {
                case "http://jabber.org/protocol/bytestreams": {
                    byteStreamSessionStage = CompletionStages.withFallback(this.socks5ByteStreamManager.initiateSession(receiver, sessionId), (future, throwable) -> {
                        logger.log(Level.FINE, "SOCKS5 file transfer failed, falling back to IBB", (Throwable)throwable);
                        return this.inBandByteStreamManager.initiateSession(receiver, sessionId, 4096);
                    });
                    break;
                }
                case "http://jabber.org/protocol/ibb": {
                    byteStreamSessionStage = this.inBandByteStreamManager.initiateSession(receiver, sessionId, 4096);
                    break;
                }
                default: {
                    throw new CompletionException(new IOException("Receiver returned unsupported stream method."));
                }
            }
            return byteStreamSessionStage.thenApply(byteStreamSession -> {
                try {
                    return byteStreamSession.getOutputStream();
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            });
        });
    }

    @Override
    public AsyncResult<FileTransfer> accept(IQ iq, String sessionId, FileTransferOffer fileTransferOffer, Object protocol, OutputStream outputStream) {
        StreamInitiation streamInitiation = (StreamInitiation)protocol;
        DataForm.Field field = streamInitiation.getFeatureNegotiation().getDataForm().findField(STREAM_METHOD);
        List offeredStreamMethods = field.getOptions().stream().map(DataForm.Option::getValue).collect(Collectors.toList());
        offeredStreamMethods.retainAll(this.getSupportedStreamMethods());
        DataForm.Field fieldReply = DataForm.Field.builder().var(STREAM_METHOD).values(offeredStreamMethods).type(DataForm.Field.Type.LIST_SINGLE).build();
        DataForm dataForm = new DataForm(DataForm.Type.SUBMIT, Collections.singleton(fieldReply));
        StreamInitiation siResponse = new StreamInitiation(new FeatureNegotiation(dataForm));
        CompletableFuture<ByteStreamSession> completableFutureS5b = new CompletableFuture<ByteStreamSession>();
        CompletableFuture<ByteStreamSession> completableFutureIbb = new CompletableFuture<ByteStreamSession>();
        Consumer<ByteStreamEvent> byteStreamListenerS5b = StreamInitiationManager.createSessionListener(sessionId, completableFutureS5b);
        Consumer<ByteStreamEvent> byteStreamListenerIbb = StreamInitiationManager.createSessionListener(sessionId, completableFutureIbb);
        this.socks5ByteStreamManager.addByteStreamListener(byteStreamListenerS5b);
        this.inBandByteStreamManager.addByteStreamListener(byteStreamListenerIbb);
        this.xmppSession.send((StreamElement)iq.createResult((Object)siResponse));
        CompletionStage eitherS5bOrIbb = completableFutureS5b.applyToEither(completableFutureIbb, Function.identity());
        CompletionStage withFallbackStage = CompletionStages.withFallback((CompletionStage)eitherS5bOrIbb, (f, t) -> completableFutureIbb);
        return new AsyncResult(withFallbackStage.applyToEither(CompletionStages.timeoutAfter((long)(this.xmppSession.getConfiguration().getDefaultResponseTimeout() * 3), (TimeUnit)TimeUnit.MILLISECONDS), byteStreamSession -> {
            try {
                return new FileTransfer(byteStreamSession.getInputStream(), outputStream, fileTransferOffer.getSize());
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        })).whenComplete((byteStreamSession, throwable) -> {
            this.socks5ByteStreamManager.removeByteStreamListener(byteStreamListenerS5b);
            this.inBandByteStreamManager.removeByteStreamListener(byteStreamListenerIbb);
        });
    }

    private static Consumer<ByteStreamEvent> createSessionListener(String sessionId, CompletableFuture<ByteStreamSession> completableFuture) {
        return e -> {
            if (sessionId.equals(e.getSessionId())) {
                e.accept().whenComplete((byteStreamSession, throwable) -> {
                    if (throwable != null) {
                        completableFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        completableFuture.complete((ByteStreamSession)byteStreamSession);
                    }
                });
            }
        };
    }

    @Override
    public void reject(IQ iq) {
        this.xmppSession.send((StreamElement)iq.createError(Condition.FORBIDDEN));
    }

    Collection<String> getSupportedStreamMethods() {
        ArrayDeque<String> allStreamMethods = new ArrayDeque<String>(Arrays.asList("http://jabber.org/protocol/bytestreams", "http://jabber.org/protocol/ibb"));
        allStreamMethods.retainAll(this.xmppSession.getEnabledFeatures());
        return allStreamMethods;
    }

    private static interface ProfileManager {
        public void handle(IQ var1, StreamInitiation var2);
    }
}

