/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.receipts;

import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.receipts.MessageDeliveredEvent;
import rocks.xmpp.extensions.receipts.model.MessageDeliveryReceipts;
import rocks.xmpp.util.XmppUtils;

public final class MessageDeliveryReceiptsManager
extends Manager {
    private static final Predicate<Message> DEFAULT_FILTER = message -> message.getType() != Message.Type.ERROR && !message.hasExtension(MessageDeliveryReceipts.Received.class) && message.getId() != null && !message.hasExtension(MessageDeliveryReceipts.Request.class);
    final Set<Consumer<MessageDeliveredEvent>> messageDeliveredListeners = new CopyOnWriteArraySet<Consumer<MessageDeliveredEvent>>();
    private final Consumer<MessageEvent> inboundMessageListener = e -> {
        MessageDeliveryReceipts.Received received;
        Message message = e.getMessage();
        if (message.hasExtension(MessageDeliveryReceipts.Request.class) && message.getId() != null) {
            Message receiptMessage = new Message(message.getFrom(), Message.Type.NORMAL);
            receiptMessage.addExtension((Object)new MessageDeliveryReceipts.Received(message.getId()));
            xmppSession.send((StreamElement)receiptMessage);
        }
        if ((received = (MessageDeliveryReceipts.Received)message.getExtension(MessageDeliveryReceipts.Received.class)) != null) {
            XmppUtils.notifyEventListeners(this.messageDeliveredListeners, (EventObject)new MessageDeliveredEvent((Object)this, received.getId(), DelayedDelivery.sendDate((Stanza)message)));
        }
    };
    private final Consumer<MessageEvent> outboundMessageListener = e -> {
        Predicate<Message> predicate;
        Message message = e.getMessage();
        MessageDeliveryReceiptsManager messageDeliveryReceiptsManager = this;
        synchronized (messageDeliveryReceiptsManager) {
            predicate = this.messageFilter != null ? DEFAULT_FILTER.and(this.messageFilter) : DEFAULT_FILTER;
        }
        if (!predicate.test(message)) {
            return;
        }
        message.addExtension((Object)MessageDeliveryReceipts.REQUEST);
    };
    private Predicate<Message> messageFilter;

    private MessageDeliveryReceiptsManager(XmppSession xmppSession) {
        super(xmppSession, true);
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundMessageListener(this.inboundMessageListener);
        this.xmppSession.addOutboundMessageListener(this.outboundMessageListener);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundMessageListener(this.inboundMessageListener);
        this.xmppSession.removeOutboundMessageListener(this.outboundMessageListener);
    }

    public void addMessageDeliveredListener(Consumer<MessageDeliveredEvent> messageDeliveredListener) {
        this.messageDeliveredListeners.add(messageDeliveredListener);
    }

    public void removeMessageDeliveredListener(Consumer<MessageDeliveredEvent> messageDeliveredListener) {
        this.messageDeliveredListeners.remove(messageDeliveredListener);
    }

    public synchronized void setMessageFilter(Predicate<Message> messageFilter) {
        this.messageFilter = messageFilter;
    }

    protected void dispose() {
        this.messageDeliveredListeners.clear();
    }
}

