/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.register;

import java.util.concurrent.CompletableFuture;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.extensions.register.model.Registration;
import rocks.xmpp.extensions.register.model.feature.RegisterFeature;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class RegistrationManager
extends Manager {
    private RegistrationManager(XmppSession xmppSession) {
        super(xmppSession);
    }

    public final AsyncResult<Boolean> isRegistrationSupported() {
        boolean isSupported = ((StreamFeaturesManager)this.xmppSession.getManager(StreamFeaturesManager.class)).getFeatures().containsKey(RegisterFeature.class);
        if (!isSupported) {
            EntityCapabilitiesManager entityCapabilitiesManager = (EntityCapabilitiesManager)this.xmppSession.getManager(EntityCapabilitiesManager.class);
            return entityCapabilitiesManager.discoverCapabilities(this.xmppSession.getDomain()).thenApply(infoNode -> infoNode.getFeatures().contains("jabber:iq:register"));
        }
        return new AsyncResult(CompletableFuture.completedFuture(true));
    }

    public final AsyncResult<Registration> getRegistration() {
        return this.xmppSession.query(IQ.get((Object)Registration.empty()), Registration.class);
    }

    public final AsyncResult<Void> register(Registration registration) {
        return this.xmppSession.query(IQ.set((Object)registration), Void.class);
    }

    public final AsyncResult<Void> cancelRegistration() {
        return this.xmppSession.query(IQ.set((Object)Registration.remove()), Void.class);
    }

    public final AsyncResult<Void> changePassword(String username, String password) {
        return this.xmppSession.query(IQ.set((Object)Registration.builder().username(username).password(password).build()), Void.class);
    }
}

