/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.blocking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.blocking.BlockingEvent;
import rocks.xmpp.extensions.blocking.model.Block;
import rocks.xmpp.extensions.blocking.model.BlockList;
import rocks.xmpp.extensions.blocking.model.Unblock;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class BlockingManager
extends Manager {
    private final Set<Jid> blockedContacts = new HashSet<Jid>();
    private final Set<Consumer<BlockingEvent>> blockingListeners = new CopyOnWriteArraySet<Consumer<BlockingEvent>>();
    private final IQHandler iqHandler;

    private BlockingManager(final XmppSession xmppSession) {
        super(xmppSession, true);
        this.iqHandler = new AbstractIQHandler(IQ.Type.SET){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IQ processRequest(IQ iq) {
                if (iq.getFrom() == null || iq.getFrom().equals((Object)xmppSession.getConnectedResource().asBareJid())) {
                    Block block = (Block)iq.getExtension(Block.class);
                    if (block != null) {
                        ArrayList<Jid> pushedContacts = new ArrayList<Jid>();
                        Set set = BlockingManager.this.blockedContacts;
                        synchronized (set) {
                            for (Jid item : block.getItems()) {
                                BlockingManager.this.blockedContacts.add(item);
                                pushedContacts.add(item);
                            }
                        }
                        XmppUtils.notifyEventListeners((Iterable)BlockingManager.this.blockingListeners, (EventObject)new BlockingEvent((Object)BlockingManager.this, pushedContacts, Collections.emptyList()));
                        return iq.createResult();
                    }
                    Unblock unblock = (Unblock)iq.getExtension(Unblock.class);
                    if (unblock != null) {
                        ArrayList<Jid> pushedContacts = new ArrayList<Jid>();
                        Set set = BlockingManager.this.blockedContacts;
                        synchronized (set) {
                            if (unblock.getItems().isEmpty()) {
                                pushedContacts.addAll(BlockingManager.this.blockedContacts);
                                BlockingManager.this.blockedContacts.clear();
                            } else {
                                for (Jid item : unblock.getItems()) {
                                    BlockingManager.this.blockedContacts.remove(item);
                                    pushedContacts.add(item);
                                }
                            }
                        }
                        XmppUtils.notifyEventListeners((Iterable)BlockingManager.this.blockingListeners, (EventObject)new BlockingEvent((Object)BlockingManager.this, Collections.emptyList(), pushedContacts));
                        return iq.createResult();
                    }
                }
                return iq.createError(Condition.NOT_ACCEPTABLE);
            }
        };
    }

    protected final void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(Block.class, this.iqHandler, false);
        this.xmppSession.addIQHandler(Unblock.class, this.iqHandler, false);
    }

    protected final void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(Block.class);
        this.xmppSession.removeIQHandler(Unblock.class);
    }

    public final void addBlockingListener(Consumer<BlockingEvent> blockingListener) {
        this.blockingListeners.add(blockingListener);
    }

    public final void removeBlockingListener(Consumer<BlockingEvent> blockingListener) {
        this.blockingListeners.remove(blockingListener);
    }

    public final AsyncResult<Set<Jid>> getBlockedContacts() {
        return this.xmppSession.query(IQ.get((Object)new BlockList())).thenApply(result -> {
            BlockList blockList = (BlockList)result.getExtension(BlockList.class);
            Set<Jid> set = this.blockedContacts;
            synchronized (set) {
                if (blockList != null) {
                    this.blockedContacts.addAll(blockList.getItems().stream().collect(Collectors.toList()));
                }
            }
            return this.blockedContacts;
        });
    }

    public final AsyncResult<IQ> blockContact(Jid ... jids) {
        return this.xmppSession.query(IQ.set((Object)new Block(Arrays.asList(jids))));
    }

    public final AsyncResult<IQ> unblockContact(Jid ... jids) {
        return this.xmppSession.query(IQ.set((Object)new Unblock(Arrays.asList(jids))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        this.blockingListeners.clear();
        Set<Jid> set = this.blockedContacts;
        synchronized (set) {
            this.blockedContacts.clear();
        }
    }
}

