/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.jingle.JingleEvent;
import rocks.xmpp.extensions.jingle.JingleSession;
import rocks.xmpp.extensions.jingle.apps.model.ApplicationFormat;
import rocks.xmpp.extensions.jingle.model.Jingle;
import rocks.xmpp.extensions.jingle.model.errors.UnknownSession;
import rocks.xmpp.util.XmppUtils;

public final class JingleManager
extends Manager {
    private final Set<Consumer<JingleEvent>> jingleListeners = new CopyOnWriteArraySet<Consumer<JingleEvent>>();
    private final Map<String, JingleSession> jingleSessionMap = new ConcurrentHashMap<String, JingleSession>();
    private final Map<Class<? extends ApplicationFormat>, Consumer<JingleSession>> registeredApplicationFormats = new ConcurrentHashMap<Class<? extends ApplicationFormat>, Consumer<JingleSession>>();

    private JingleManager(XmppSession xmppSession) {
        super(xmppSession, true);
    }

    protected void initialize() {
        this.xmppSession.addIQHandler(Jingle.class, (IQHandler)new AbstractIQHandler(IQ.Type.SET){

            public IQ processRequest(IQ iq) {
                JingleSession jingleSession;
                Jingle jingle = (Jingle)iq.getExtension(Jingle.class);
                if (jingle.getAction() == null) {
                    return iq.createError(new StanzaError(Condition.BAD_REQUEST, "No valid action attribute set."));
                }
                if (jingle.getSessionId() == null) {
                    return iq.createError(new StanzaError(Condition.BAD_REQUEST, "No session id set."));
                }
                if (jingle.getAction() == Jingle.Action.SESSION_INITIATE) {
                    if (jingle.getContents().isEmpty()) {
                        return iq.createError(new StanzaError(Condition.BAD_REQUEST, "No contents found."));
                    }
                    boolean hasContentWithDispositionSession = false;
                    boolean hasSupportedApplications = false;
                    boolean hasSupportedTransports = false;
                    for (Jingle.Content content : jingle.getContents()) {
                        if (!hasContentWithDispositionSession && ("session".equals(content.getDisposition()) || content.getDisposition() == null)) {
                            hasContentWithDispositionSession = true;
                        }
                        if (!hasSupportedApplications && content.getApplicationFormat() != null) {
                            hasSupportedApplications = true;
                        }
                        if (hasSupportedTransports || content.getTransportMethod() == null) continue;
                        hasSupportedTransports = true;
                    }
                    if (!hasContentWithDispositionSession) {
                        return iq.createError(new StanzaError(Condition.BAD_REQUEST, "No content with disposition 'session' found."));
                    }
                    if (!hasSupportedApplications) {
                        return IQ.set((Jid)iq.getFrom(), (Object)new Jingle(jingle.getSessionId(), Jingle.Action.SESSION_TERMINATE, new Jingle.Reason((Jingle.Reason.Condition)new Jingle.Reason.UnsupportedApplications())));
                    }
                    if (!hasSupportedTransports) {
                        return IQ.set((Jid)iq.getFrom(), (Object)new Jingle(jingle.getSessionId(), Jingle.Action.SESSION_TERMINATE, new Jingle.Reason((Jingle.Reason.Condition)new Jingle.Reason.UnsupportedTransports())));
                    }
                    jingleSession = new JingleSession(jingle.getSessionId(), iq.getFrom(), false, JingleManager.this.xmppSession, JingleManager.this, jingle.getContents());
                    JingleManager.this.jingleSessionMap.put(jingle.getSessionId(), jingleSession);
                    Consumer consumer = (Consumer)JingleManager.this.registeredApplicationFormats.get(((Jingle.Content)jingle.getContents().get(0)).getApplicationFormat().getClass());
                    if (consumer != null) {
                        consumer.accept(jingleSession);
                    }
                } else {
                    jingleSession = (JingleSession)JingleManager.this.jingleSessionMap.get(jingle.getSessionId());
                }
                if (jingleSession == null) {
                    return iq.createError(new StanzaError(Condition.ITEM_NOT_FOUND, (Object)new UnknownSession()));
                }
                ForkJoinPool.commonPool().execute(() -> XmppUtils.notifyEventListeners(jingleSession.jingleListeners, (EventObject)new JingleEvent((Object)JingleManager.this, JingleManager.this.xmppSession, iq, jingle)));
                return iq.createResult();
            }
        });
    }

    public JingleSession createSession(Jid responder, String sessionId, Jingle.Content ... contents) {
        Objects.requireNonNull(responder, "responder must not be null.");
        if (contents.length == 0) {
            throw new IllegalArgumentException("no content provided.");
        }
        JingleSession jingleSession = new JingleSession(sessionId, responder, true, this.xmppSession, this, contents);
        this.jingleSessionMap.put(sessionId, jingleSession);
        return jingleSession;
    }

    void removeSession(String sessionId) {
        this.jingleSessionMap.remove(sessionId);
    }

    public final void addJingleListener(Consumer<JingleEvent> jingleListener) {
        this.jingleListeners.add(jingleListener);
    }

    public final void removeJingleListener(Consumer<JingleEvent> jingleListener) {
        this.jingleListeners.remove(jingleListener);
    }

    public final void registerApplicationFormat(Class<? extends ApplicationFormat> applicationFormat, Consumer<JingleSession> consumer) {
        this.registeredApplicationFormats.put(applicationFormat, consumer);
    }

    public final void unregisterApplicationFormat(Class<? extends ApplicationFormat> applicationFormat) {
        this.registeredApplicationFormats.remove(applicationFormat);
    }

    protected void dispose() {
        this.jingleListeners.clear();
        this.jingleSessionMap.clear();
    }
}

