/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.component.accept;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.SendTask;
import rocks.xmpp.core.session.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.component.accept.model.ComponentIQ;
import rocks.xmpp.extensions.component.accept.model.ComponentMessage;
import rocks.xmpp.extensions.component.accept.model.ComponentPresence;
import rocks.xmpp.extensions.component.accept.model.Handshake;

public final class ExternalComponent
extends XmppSession {
    private static final Logger logger = Logger.getLogger(ExternalComponent.class.getName());
    private final Lock lock = new ReentrantLock();
    private final Condition streamOpened = this.lock.newCondition();
    private final Condition handshakeReceived = this.lock.newCondition();
    private final String sharedSecret;
    private volatile Jid connectedResource;
    private volatile boolean streamHeaderReceived;

    @Deprecated
    public ExternalComponent(String componentName, String sharedSecret, String hostname, int port) {
        this(componentName, sharedSecret, XmppSessionConfiguration.getDefault(), hostname, port);
    }

    @Deprecated
    public ExternalComponent(String componentName, String sharedSecret, XmppSessionConfiguration configuration, String hostname, int port) {
        super(componentName, configuration, new ConnectionConfiguration[]{((TcpConnectionConfiguration.Builder)((TcpConnectionConfiguration.Builder)TcpConnectionConfiguration.builder().hostname(hostname)).port(port)).build()});
        this.sharedSecret = sharedSecret;
    }

    public static ExternalComponent create(String componentName, String sharedSecret, String hostname, int port) {
        return ExternalComponent.create(componentName, sharedSecret, XmppSessionConfiguration.getDefault(), hostname, port);
    }

    public static ExternalComponent create(String componentName, String sharedSecret, XmppSessionConfiguration configuration, String hostname, int port) {
        ExternalComponent component = new ExternalComponent(componentName, sharedSecret, configuration, hostname, port);
        ExternalComponent.notifyCreationListeners((XmppSession)component);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(Jid from) throws XmppException {
        XmppSession.Status previousStatus = this.preConnect();
        try {
            if (!this.checkConnected()) {
                this.updateStatus(XmppSession.Status.CONNECTING);
                ExternalComponent externalComponent = this;
                synchronized (externalComponent) {
                    if (!this.checkConnected()) {
                        this.exception = null;
                        this.streamHeaderReceived = false;
                        this.tryConnect(from, "jabber:component:accept", this::onStreamOpened);
                        logger.fine("Negotiating stream, waiting until handshake is ready to be negotiated.");
                        this.lock.lock();
                        try {
                            if (!this.streamHeaderReceived) {
                                this.streamOpened.await(this.configuration.getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
                            }
                        }
                        finally {
                            this.lock.unlock();
                        }
                        Thread.sleep(20L);
                        ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)this.exception);
                        this.connectedResource = this.getDomain();
                    }
                }
            }
            this.updateStatus(XmppSession.Status.CONNECTING, XmppSession.Status.CONNECTED);
            this.login(this.sharedSecret);
        }
        catch (Throwable e) {
            this.onConnectionFailed(previousStatus, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(String sharedSecret) throws XmppException {
        XmppSession.Status previousStatus = this.preLogin();
        try {
            if (this.checkAuthenticated()) {
                return;
            }
            this.updateStatus(XmppSession.Status.AUTHENTICATING);
            ExternalComponent externalComponent = this;
            synchronized (externalComponent) {
                if (this.checkAuthenticated()) {
                    return;
                }
                this.send((StreamElement)Handshake.create((String)this.getActiveConnection().getStreamId(), (String)sharedSecret));
                this.lock.lock();
                try {
                    this.handshakeReceived.await(this.configuration.getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.updateStatus(XmppSession.Status.AUTHENTICATED);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)this.exception);
            this.afterLogin();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.updateStatus(previousStatus, e);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)e);
        }
        catch (Throwable e) {
            this.updateStatus(previousStatus, e);
            ExternalComponent.throwAsXmppExceptionIfNotNull((Throwable)e);
        }
    }

    public final boolean handleElement(Object element) throws XmppException {
        if (element instanceof Handshake) {
            this.releaseLock();
        } else {
            super.handleElement(element);
        }
        return false;
    }

    public final void notifyException(Throwable e) {
        super.notifyException(e);
        this.releaseLock();
    }

    private void releaseLock() {
        this.lock.lock();
        try {
            this.handshakeReceived.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onStreamOpened(Jid domain) {
        this.setXmppServiceDomain(domain);
        this.streamHeaderReceived = true;
        this.lock.lock();
        try {
            this.streamOpened.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public final Jid getConnectedResource() {
        return this.connectedResource;
    }

    public final Future<Void> send(StreamElement element) {
        if (element instanceof Stanza && ((Stanza)element).getFrom() == null) {
            ((Stanza)element).setFrom(this.connectedResource);
        }
        if (element instanceof Message) {
            element = ComponentMessage.from((Message)((Message)element));
        } else if (element instanceof Presence) {
            element = ComponentPresence.from((Presence)((Presence)element));
        } else if (element instanceof IQ) {
            element = ComponentIQ.from((IQ)((IQ)element));
        }
        return super.send(element);
    }

    public final SendTask<IQ> sendIQ(IQ iq) {
        return this.trackAndSend((Stanza)ComponentIQ.from((IQ)iq));
    }

    public final SendTask<Message> sendMessage(Message message) {
        return this.trackAndSend((Stanza)ComponentMessage.from((Message)message));
    }

    public final SendTask<Presence> sendPresence(Presence presence) {
        return this.trackAndSend((Stanza)ComponentPresence.from((Presence)presence));
    }
}

