/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.extensions.bytestreams.ibb.IbbSession;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;

final class IbbInputStream
extends InputStream {
    final BlockingQueue<InBandByteStream.Data> queue = new LinkedBlockingQueue<InBandByteStream.Data>();
    private final IbbSession ibbSession;
    private final long readTimeout;
    private byte[] buffer;
    private int n = 0;
    private boolean closed;

    IbbInputStream(IbbSession ibbSession, long readTimeout) {
        this.ibbSession = ibbSession;
        this.readTimeout = readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.n == 0) {
            try {
                IbbInputStream ibbInputStream;
                long timeout;
                IbbInputStream ibbInputStream2 = this;
                synchronized (ibbInputStream2) {
                    if (this.closed && this.queue.isEmpty()) {
                        return -1;
                    }
                    timeout = this.readTimeout;
                }
                InBandByteStream.Data data = null;
                if (timeout <= 0L) {
                    while (data == null || data.getSequence() == -1) {
                        ibbInputStream = this;
                        synchronized (ibbInputStream) {
                            if (this.closed && this.queue.isEmpty()) {
                                return -1;
                            }
                        }
                        data = this.queue.poll(1L, TimeUnit.SECONDS);
                    }
                } else {
                    data = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
                    if (data == null || data.getSequence() == -1) {
                        IbbInputStream ibbInputStream3 = this;
                        synchronized (ibbInputStream3) {
                            if (this.closed && this.queue.isEmpty()) {
                                return -1;
                            }
                            throw new SocketTimeoutException();
                        }
                    }
                }
                ibbInputStream = this;
                synchronized (ibbInputStream) {
                    this.buffer = data.getBytes();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                InterruptedIOException ie = new InterruptedIOException();
                ie.initCause(e);
                throw ie;
            }
        }
        IbbInputStream ibbInputStream = this;
        synchronized (ibbInputStream) {
            int b = this.buffer[this.n++] & 0xFF;
            if (this.n >= this.buffer.length) {
                this.n = 0;
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        IbbInputStream ibbInputStream = this;
        synchronized (ibbInputStream) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        super.close();
        try {
            this.ibbSession.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.queue.add(new InBandByteStream.Data(new byte[0], this.ibbSession.getSessionId(), -1));
    }
}

