/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.awt.image.BufferedImage;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.avatar.AvatarManager;

public final class AvatarChangeEvent
extends EventObject {
    private static final Logger LOGGER = Logger.getLogger(AvatarManager.class.getName());
    private final Jid contact;
    private final byte[] avatar;

    AvatarChangeEvent(AvatarManager source, Jid contact, byte[] avatar) {
        super((Object)source);
        this.contact = contact;
        this.avatar = avatar;
    }

    public final byte[] getAvatar() {
        return this.avatar;
    }

    public final BufferedImage getAvatarImage() {
        try {
            return this.avatar == null ? null : AvatarManager.asBufferedImage(this.avatar);
        }
        catch (AvatarManager.ConversionException e) {
            LOGGER.log(Level.SEVERE, "Cannot convert avatar image");
            return null;
        }
    }

    public final Jid getContact() {
        return this.contact;
    }
}

