/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.address.model.Address;
import rocks.xmpp.extensions.address.model.Addresses;
import rocks.xmpp.extensions.avatar.AvatarChangeEvent;
import rocks.xmpp.extensions.avatar.model.data.AvatarData;
import rocks.xmpp.extensions.avatar.model.metadata.AvatarMetadata;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.pubsub.PubSubManager;
import rocks.xmpp.extensions.pubsub.PubSubService;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.event.Event;
import rocks.xmpp.extensions.vcard.avatar.model.AvatarUpdate;
import rocks.xmpp.extensions.vcard.temp.VCardManager;
import rocks.xmpp.extensions.vcard.temp.model.VCard;
import rocks.xmpp.im.subscription.PresenceManager;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.cache.DirectoryCache;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class AvatarManager
extends Manager {
    private static final Logger logger = Logger.getLogger(VCardManager.class.getName());
    private final Map<Jid, String> userHashes = new ConcurrentHashMap<Jid, String>();
    private final Map<Jid, AsyncResult<byte[]>> avatarRequests = new ConcurrentHashMap<Jid, AsyncResult<byte[]>>();
    private final Set<Consumer<AvatarChangeEvent>> avatarChangeListeners = new CopyOnWriteArraySet<Consumer<AvatarChangeEvent>>();
    private final VCardManager vCardManager;
    private final Set<String> nonConformingResources = Collections.synchronizedSet(new HashSet());
    private final Map<String, byte[]> avatarCache;
    private final Consumer<PresenceEvent> inboundPresenceListener;
    private final Consumer<PresenceEvent> outboundPresenceListener;
    private final Consumer<MessageEvent> inboundMessageListener;

    private AvatarManager(XmppSession xmppSession) {
        super(xmppSession, true);
        this.vCardManager = (VCardManager)xmppSession.getManager(VCardManager.class);
        this.avatarCache = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("avatars")) : null;
        this.inboundPresenceListener = e -> {
            Jid contact;
            Presence presence = e.getPresence();
            AvatarUpdate avatarUpdate = (AvatarUpdate)presence.getExtension(AvatarUpdate.class);
            if (presence.getFrom().asBareJid().equals((Object)xmppSession.getConnectedResource().asBareJid()) && presence.getFrom().getResource() != null && !presence.getFrom().getResource().equals(xmppSession.getConnectedResource().getResource())) {
                if (avatarUpdate == null) {
                    if (presence.isAvailable()) {
                        this.nonConformingResources.add(presence.getFrom().getResource());
                    } else if (presence.getType() == Presence.Type.UNAVAILABLE && this.nonConformingResources.remove(presence.getFrom().getResource()) && this.nonConformingResources.isEmpty()) {
                        this.resetHash();
                    }
                } else if (avatarUpdate.getHash() != null && !avatarUpdate.getHash().equals(this.userHashes.get(xmppSession.getConnectedResource().asBareJid()))) {
                    this.resetHash();
                }
            }
            if (avatarUpdate == null || avatarUpdate.getHash() == null) return;
            MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
            if (mucUser != null) {
                if (mucUser.getItem() == null || mucUser.getItem().getJid() == null) return;
                contact = mucUser.getItem().getJid().asBareJid();
            } else {
                contact = presence.getFrom().asBareJid();
            }
            if (avatarUpdate.getHash().equals(this.userHashes.put(contact, avatarUpdate.getHash()))) return;
            byte[] imageData = this.loadFromCache(avatarUpdate.getHash());
            byte[] avatar = null;
            if (imageData != null) {
                avatar = imageData;
            }
            if (avatar != null) {
                this.notifyListeners(contact, avatar);
                return;
            } else {
                this.getAvatarByVCard(contact).whenComplete((avatarResult, ex) -> {
                    if (ex == null) {
                        this.notifyListeners(contact, (byte[])avatarResult);
                    } else {
                        logger.log(Level.WARNING, (Throwable)ex, () -> "Failed to retrieve vCard based avatar for user: " + contact);
                    }
                });
            }
        };
        this.outboundPresenceListener = e -> {
            Presence presence = e.getPresence();
            if (presence.isAvailable() && this.nonConformingResources.isEmpty()) {
                String myHash = this.userHashes.get(xmppSession.getConnectedResource().asBareJid());
                if (myHash == null) {
                    presence.addExtension((Object)new AvatarUpdate());
                    this.getAvatarByVCard(xmppSession.getConnectedResource().asBareJid()).whenComplete((avatarResult, ex) -> {
                        if (ex == null) {
                            this.notifyListeners(xmppSession.getConnectedResource().asBareJid(), (byte[])avatarResult);
                            Presence lastPresence = ((PresenceManager)xmppSession.getManager(PresenceManager.class)).getLastSentPresence();
                            Presence presence1 = lastPresence != null ? new Presence(null, lastPresence.getType(), lastPresence.getShow(), (Collection)lastPresence.getStatuses(), lastPresence.getPriority(), null, null, lastPresence.getLanguage(), null, null) : new Presence();
                            xmppSession.send((StreamElement)presence1);
                        } else {
                            logger.warning("Failed to retrieve own vCard based avatar.");
                        }
                    });
                } else if (!presence.hasExtension(AvatarUpdate.class)) {
                    presence.addExtension((Object)new AvatarUpdate(myHash));
                }
            }
        };
        this.inboundMessageListener = e -> {
            Message message = e.getMessage();
            Event event = (Event)message.getExtension(Event.class);
            if (event != null) {
                Addresses addresses = (Addresses)message.getExtension(Addresses.class);
                if (addresses != null) {
                    for (Address address : addresses.getAddresses()) {
                        if (address.getType() != Address.Type.REPLYTO || !xmppSession.getConnectedResource().equals((Object)address.getJid())) continue;
                        return;
                    }
                }
                for (Item item : event.getItems()) {
                    if (!(item.getPayload() instanceof AvatarMetadata)) continue;
                    AvatarMetadata avatarMetadata = (AvatarMetadata)item.getPayload();
                    if (avatarMetadata.getInfoList().isEmpty()) {
                        this.notifyListeners(message.getFrom().asBareJid(), null);
                        continue;
                    }
                    byte[] cachedImage = this.loadFromCache(item.getId());
                    if (cachedImage != null) {
                        this.notifyListeners(message.getFrom().asBareJid(), cachedImage);
                        continue;
                    }
                    AvatarMetadata.Info chosenInfo = null;
                    for (AvatarMetadata.Info info : avatarMetadata.getInfoList()) {
                        if (info.getUrl() != null) continue;
                        chosenInfo = info;
                    }
                    if (chosenInfo == null) {
                        for (AvatarMetadata.Info info : avatarMetadata.getInfoList()) {
                            if (info.getUrl() == null) continue;
                            chosenInfo = info;
                            break;
                        }
                    }
                    if (chosenInfo != null && chosenInfo.getUrl() != null) {
                        try {
                            URLConnection urlConnection = chosenInfo.getUrl().openConnection();
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            try (InputStream in = urlConnection.getInputStream();){
                                int n;
                                byte[] data = new byte[4096];
                                while ((n = in.read(data, 0, 4096)) != -1) {
                                    baos.write(data, 0, n);
                                }
                            }
                            byte[] data = baos.toByteArray();
                            this.storeToCache(item.getId(), data);
                            this.notifyListeners(message.getFrom().asBareJid(), data);
                        }
                        catch (IOException e1) {
                            logger.log(Level.WARNING, "Failed to download avatar from advertised URL: {0}.", chosenInfo.getUrl());
                        }
                        continue;
                    }
                    PubSubService pubSubService = ((PubSubManager)xmppSession.getManager(PubSubManager.class)).createPubSubService(message.getFrom());
                    pubSubService.node("urn:xmpp:avatar:data").getItems(item.getId()).whenComplete((items, ex) -> {
                        Item i;
                        if (ex != null) {
                            logger.log(Level.WARNING, () -> String.format("Failed to retrieve avatar '%s' from PEP service for user '%s'", item.getId(), message.getFrom()));
                        } else if (!items.isEmpty() && (i = (Item)items.get(0)).getPayload() instanceof AvatarData) {
                            AvatarData avatarData = (AvatarData)i.getPayload();
                            this.storeToCache(item.getId(), avatarData.getData());
                            this.notifyListeners(message.getFrom().asBareJid(), avatarData.getData());
                        }
                    });
                }
            }
        };
    }

    protected final void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.addOutboundPresenceListener(this.outboundPresenceListener);
        this.xmppSession.addInboundMessageListener(this.inboundMessageListener);
    }

    protected final void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundPresenceListener(this.inboundPresenceListener);
        this.xmppSession.removeOutboundPresenceListener(this.outboundPresenceListener);
        this.xmppSession.removeInboundMessageListener(this.inboundMessageListener);
    }

    private void resetHash() {
        this.userHashes.remove(this.xmppSession.getConnectedResource().asBareJid());
        Presence presence = ((PresenceManager)this.xmppSession.getManager(PresenceManager.class)).getLastSentPresence();
        if (presence == null) {
            presence = new Presence();
        }
        presence.getExtensions().clear();
        this.xmppSession.send((StreamElement)presence);
    }

    private void notifyListeners(Jid contact, byte[] avatar) {
        XmppUtils.notifyEventListeners(this.avatarChangeListeners, (EventObject)new AvatarChangeEvent(this, contact, avatar));
    }

    private AsyncResult<byte[]> getAvatarByVCard(Jid contact) {
        String hash = this.userHashes.get(contact);
        if (!"".equals(hash)) {
            byte[] imageData;
            if (hash != null && (imageData = this.loadFromCache(hash)) != null) {
                return new AsyncResult(CompletableFuture.completedFuture(imageData));
            }
            return this.avatarRequests.computeIfAbsent(contact, key -> {
                VCardManager vCardManager = (VCardManager)this.xmppSession.getManager(VCardManager.class);
                AsyncResult<VCard> vCard = contact.equals((Object)this.xmppSession.getConnectedResource().asBareJid()) ? vCardManager.getVCard() : vCardManager.getVCard(contact);
                return vCard.handle((result, exc) -> {
                    VCard.Image image;
                    byte[] avatar = new byte[]{};
                    String hash1 = "";
                    if (result != null && (image = result.getPhoto()) != null && image.getValue() != null) {
                        hash1 = XmppUtils.hash((byte[])image.getValue());
                        avatar = image.getValue();
                    }
                    this.userHashes.put(contact, hash1);
                    if (!Arrays.equals(avatar, new byte[0])) {
                        this.storeToCache(hash, avatar);
                    }
                    this.avatarRequests.remove(contact);
                    return avatar;
                });
            });
        }
        return new AsyncResult(CompletableFuture.completedFuture(new byte[0]));
    }

    private byte[] loadFromCache(String hash) {
        if (this.avatarCache != null) {
            try {
                return this.avatarCache.get(hash + ".avatar");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not read avatar from cache.", e);
            }
        }
        return null;
    }

    private void storeToCache(String hash, byte[] image) {
        if (this.avatarCache != null) {
            try {
                this.avatarCache.put(hash + ".avatar", image);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not write avatar to cache.", e);
            }
        }
    }

    public final AsyncResult<byte[]> getAvatar(Jid contact) {
        return this.getAvatarByVCard(contact.asBareJid());
    }

    public final AsyncResult<BufferedImage> getAvatarImage(Jid contact) {
        return this.getAvatar(Objects.requireNonNull(contact)).thenApply(bitmap -> {
            try {
                return bitmap == null ? null : AvatarManager.asBufferedImage(bitmap);
            }
            catch (ConversionException e) {
                throw new CompletionException(e);
            }
        });
    }

    public final AsyncResult<Void> publishAvatar(byte[] imageData) {
        String hash = imageData != null ? XmppUtils.hash((byte[])imageData) : null;
        AvatarMetadata.Info info = imageData != null ? new AvatarMetadata.Info(Integer.valueOf(imageData.length), hash, hash) : null;
        return this.publishToVCard(imageData, null, hash).whenComplete((result, e) -> {
            if (e != null) {
                logger.warning("Failed to publish avatar to vCard.");
            }
        }).thenCompose(aVoid -> this.publishToPersonalEventingService(imageData, hash, info)).thenRun(() -> {});
    }

    public final AsyncResult<Void> publishAvatarImage(BufferedImage bufferedImage) throws XmppException {
        try {
            return this.publishAvatar(bufferedImage == null ? null : AvatarManager.asPNG(bufferedImage));
        }
        catch (ConversionException e) {
            throw new XmppException((Throwable)e);
        }
    }

    private AsyncResult<Void> publishToVCard(byte[] avatar, String type, String hash) {
        return this.vCardManager.getVCard().thenApply(result -> result != null ? result : new VCard()).thenAccept(vCard -> {
            if (avatar != null) {
                if (vCard.getPhoto() == null || !Arrays.equals(vCard.getPhoto().getValue(), avatar)) {
                    this.userHashes.put(this.xmppSession.getConnectedResource().asBareJid(), hash);
                    vCard.setPhoto(new VCard.Image(type, avatar));
                    this.vCardManager.setVCard((VCard)vCard);
                }
            } else {
                this.userHashes.put(this.xmppSession.getConnectedResource().asBareJid(), "");
                if (vCard.getPhoto() != null && vCard.getPhoto().getValue() != null) {
                    vCard.setPhoto(null);
                    this.vCardManager.setVCard((VCard)vCard);
                }
            }
        });
    }

    private AsyncResult<String> publishToPersonalEventingService(byte[] avatar, String itemId, AvatarMetadata.Info info) {
        PubSubService personalEventingService = ((PubSubManager)this.xmppSession.getManager(PubSubManager.class)).createPersonalEventingService();
        if (avatar != null) {
            if (info.getUrl() == null) {
                return personalEventingService.node("urn:xmpp:avatar:data").publish(itemId, new AvatarData(avatar));
            }
            return personalEventingService.node("urn:xmpp:avatar:metadata").publish(itemId, new AvatarMetadata(new AvatarMetadata.Info[]{info}));
        }
        return personalEventingService.node("urn:xmpp:avatar:metadata").publish(itemId, new AvatarMetadata(new AvatarMetadata.Info[0]));
    }

    public final void addAvatarChangeListener(Consumer<AvatarChangeEvent> avatarChangeListener) {
        this.avatarChangeListeners.add(avatarChangeListener);
    }

    public final void removeAvatarChangeListener(Consumer<AvatarChangeEvent> avatarChangeListener) {
        this.avatarChangeListeners.remove(avatarChangeListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final BufferedImage asBufferedImage(byte[] bitmap) throws ConversionException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Objects.requireNonNull(bitmap));){
            BufferedImage bufferedImage = Optional.ofNullable(ImageIO.read(inputStream)).orElseThrow(ConversionException::new);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final byte[] asPNG(BufferedImage bufferedImage) throws ConversionException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            if (!ImageIO.write((RenderedImage)Objects.requireNonNull(bufferedImage), "png", outputStream)) {
                throw new ConversionException();
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    protected void dispose() {
        this.avatarChangeListeners.clear();
        this.avatarRequests.clear();
        this.nonConformingResources.clear();
        this.userHashes.clear();
    }

    static final class ConversionException
    extends Exception {
        public ConversionException() {
        }

        public ConversionException(Throwable cause) {
            super(cause);
        }
    }
}

