/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.extensions.bytestreams.ibb.IbbSession;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;

final class IbbInputStream
extends InputStream {
    final BlockingQueue<InBandByteStream.Data> queue = new LinkedBlockingQueue<InBandByteStream.Data>();
    private final IbbSession ibbSession;
    private final long readTimeout;
    private byte[] buffer;
    private int n = -1;
    private boolean closed;

    IbbInputStream(IbbSession ibbSession, long readTimeout) {
        this.ibbSession = ibbSession;
        this.readTimeout = readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.fillBuffer()) {
            return -1;
        }
        IbbInputStream ibbInputStream = this;
        synchronized (ibbInputStream) {
            int limit = this.buffer.length - this.n;
            if (len > limit) {
                len = limit;
            }
            System.arraycopy(this.buffer, this.n, b, off, len);
            this.n += len;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (!this.fillBuffer()) {
            return -1;
        }
        IbbInputStream ibbInputStream = this;
        synchronized (ibbInputStream) {
            return this.buffer[this.n++] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillBuffer() throws IOException {
        long timeout;
        IbbInputStream ibbInputStream = this;
        synchronized (ibbInputStream) {
            if (this.closed && this.queue.isEmpty()) {
                return false;
            }
            timeout = this.readTimeout;
        }
        if (this.n == -1 || this.n >= this.buffer.length) {
            try {
                IbbInputStream ibbInputStream2;
                InBandByteStream.Data data = null;
                if (timeout <= 0L) {
                    while (data == null || data.getSequence() == -1) {
                        ibbInputStream2 = this;
                        synchronized (ibbInputStream2) {
                            if (this.closed && this.queue.isEmpty()) {
                                return false;
                            }
                        }
                        data = this.queue.poll(1L, TimeUnit.SECONDS);
                    }
                } else {
                    data = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
                    if (data == null || data.getSequence() == -1) {
                        IbbInputStream ibbInputStream3 = this;
                        synchronized (ibbInputStream3) {
                            if (this.closed && this.queue.isEmpty()) {
                                return false;
                            }
                            throw new SocketTimeoutException();
                        }
                    }
                }
                ibbInputStream2 = this;
                synchronized (ibbInputStream2) {
                    this.buffer = data.getBytes();
                    this.n = 0;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                InterruptedIOException ie = new InterruptedIOException();
                ie.initCause(e);
                throw ie;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        IbbInputStream ibbInputStream = this;
        synchronized (ibbInputStream) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        super.close();
        try {
            this.ibbSession.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.queue.add(new InBandByteStream.Data(new byte[0], this.ibbSession.getSessionId(), -1));
    }
}

