/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpauth;

import java.util.Collections;
import java.util.EventObject;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.httpauth.model.ConfirmationRequest;

public final class HttpAuthenticationEvent
extends EventObject {
    private final ConfirmationRequest confirmationRequest;
    private final XmppSession xmppSession;
    private final Stanza stanza;

    HttpAuthenticationEvent(Object source, XmppSession xmppSession, Stanza stanza, ConfirmationRequest confirmationRequest) {
        super(source);
        this.confirmationRequest = confirmationRequest;
        this.xmppSession = xmppSession;
        this.stanza = stanza;
    }

    public Jid getRequester() {
        return this.stanza.getFrom();
    }

    public ConfirmationRequest getConfirmationRequest() {
        return this.confirmationRequest;
    }

    public void confirm() {
        if (this.stanza instanceof IQ) {
            this.xmppSession.send((StreamElement)((IQ)this.stanza).createResult());
        } else if (this.stanza instanceof Message) {
            Message m = new Message(this.getRequester(), Message.Type.NORMAL, null, null, ((Message)this.stanza).getThread());
            m.addExtension((Object)this.confirmationRequest);
            this.xmppSession.send((StreamElement)m);
        }
    }

    public void deny() {
        if (this.stanza instanceof IQ) {
            this.xmppSession.send((StreamElement)((IQ)this.stanza).createError(Condition.NOT_AUTHORIZED));
        } else if (this.stanza instanceof Message) {
            this.xmppSession.send((StreamElement)new Message(this.getRequester(), Message.Type.ERROR, Collections.emptyList(), null, ((Message)this.stanza).getThread(), null, null, null, null, Collections.singleton(this.confirmationRequest), new StanzaError(Condition.NOT_AUTHORIZED)));
        }
    }
}

