/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.version;

import java.util.Properties;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.version.model.SoftwareVersion;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class SoftwareVersionManager
extends Manager {
    private static final SoftwareVersion DEFAULT_VERSION;
    private final IQHandler iqHandler = new AbstractIQHandler(IQ.Type.GET){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IQ processRequest(IQ iq) {
            SoftwareVersionManager softwareVersionManager = SoftwareVersionManager.this;
            synchronized (softwareVersionManager) {
                if (SoftwareVersionManager.this.softwareVersion != null) {
                    return iq.createResult((Object)SoftwareVersionManager.this.softwareVersion);
                }
            }
            if (DEFAULT_VERSION != null) {
                return iq.createResult((Object)DEFAULT_VERSION);
            }
            return iq.createError(Condition.SERVICE_UNAVAILABLE);
        }
    };
    private SoftwareVersion softwareVersion;

    private SoftwareVersionManager(XmppSession xmppSession) {
        super(xmppSession);
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(SoftwareVersion.class, this.iqHandler);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(SoftwareVersion.class);
    }

    public AsyncResult<SoftwareVersion> getSoftwareVersion(Jid jid) {
        return this.xmppSession.query(IQ.get((Jid)jid, (Object)new SoftwareVersion()), SoftwareVersion.class);
    }

    public synchronized SoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public synchronized void setSoftwareVersion(SoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    static {
        SoftwareVersion version;
        Properties properties = new Properties();
        try {
            properties.load(SoftwareVersionManager.class.getResourceAsStream("/META-INF/maven/rocks.xmpp/xmpp-extensions-client/pom.properties"));
            version = new SoftwareVersion("Babbler", properties.getProperty("version"));
        }
        catch (Exception e) {
            version = null;
        }
        DEFAULT_VERSION = version;
    }
}

