/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bob;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.bob.model.Data;
import rocks.xmpp.util.concurrent.AsyncResult;

class BitsOfBinaryManager
extends Manager {
    private final Map<String, Data> dataCache = new ConcurrentHashMap<String, Data>();

    private BitsOfBinaryManager(XmppSession xmppSession) {
        super(xmppSession, true);
    }

    protected void initialize() {
        this.xmppSession.addIQHandler(Data.class, (IQHandler)new AbstractIQHandler(IQ.Type.GET){

            protected IQ processRequest(IQ iq) {
                Data data = (Data)iq.getExtension(Data.class);
                Data cachedData = (Data)BitsOfBinaryManager.this.dataCache.get(data.getContentId());
                if (cachedData != null) {
                    return iq.createResult((Object)cachedData);
                }
                return iq.createError(Condition.ITEM_NOT_FOUND);
            }
        });
    }

    public AsyncResult<Data> getData(String contentId, Jid to) {
        return this.xmppSession.query(IQ.get((Jid)to, (Object)new Data(contentId))).thenApply(result -> {
            Data data = (Data)result.getExtension(Data.class);
            return data;
        });
    }

    public void put(Data data) {
        this.dataCache.put(data.getContentId(), data);
    }

    protected void dispose() {
        this.dataCache.clear();
    }
}

