/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.apps.filetransfer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.bytestreams.ibb.InBandByteStreamManager;
import rocks.xmpp.extensions.filetransfer.FileTransferRejectedException;
import rocks.xmpp.extensions.jingle.JingleManager;
import rocks.xmpp.extensions.jingle.JingleSession;
import rocks.xmpp.extensions.jingle.apps.filetransfer.JingleFileTransferSession;
import rocks.xmpp.extensions.jingle.apps.filetransfer.model.JingleFileTransfer;
import rocks.xmpp.extensions.jingle.apps.model.ApplicationFormat;
import rocks.xmpp.extensions.jingle.model.Jingle;
import rocks.xmpp.extensions.jingle.transports.ibb.model.InBandByteStreamsTransportMethod;
import rocks.xmpp.extensions.jingle.transports.model.TransportMethod;

public final class JingleFileTransferManager
extends Manager {
    private final JingleManager jingleManager;

    private JingleFileTransferManager(XmppSession xmppSession) {
        super(xmppSession);
        this.jingleManager = (JingleManager)xmppSession.getManager(JingleManager.class);
    }

    protected void onEnable() {
        super.onEnable();
        this.jingleManager.registerApplicationFormat(JingleFileTransfer.class, this::onFileTransferRequest);
    }

    protected void onDisable() {
        super.onDisable();
        this.jingleManager.unregisterApplicationFormat(JingleFileTransfer.class);
    }

    private void onFileTransferRequest(JingleSession jingleSession) {
        jingleSession.accept(jingleSession.getContents().get(0));
    }

    public JingleFileTransferSession initiateFileTransferSession(Jid responder, Path file, String description, long timeout) throws XmppException, IOException {
        JingleFileTransfer.File jingleFile = new JingleFileTransfer.File(file.getFileName().toString(), Files.size(file), Files.getLastModifiedTime(file, new LinkOption[0]).toInstant(), null, description);
        JingleFileTransfer jingleFileTransfer = new JingleFileTransfer(jingleFile);
        String sessionId = UUID.randomUUID().toString();
        InBandByteStreamsTransportMethod ibbTransportMethod = new InBandByteStreamsTransportMethod(4096, sessionId);
        Jingle.Content content = new Jingle.Content("a-file-offer", Jingle.Content.Creator.INITIATOR, (ApplicationFormat)jingleFileTransfer, (TransportMethod)ibbTransportMethod, null, Jingle.Content.Senders.INITIATOR);
        JingleSession jingleSession = this.jingleManager.createSession(responder, sessionId, content);
        CompletableFuture jingleResponseFuture = new CompletableFuture();
        jingleSession.addJingleListener(e -> {
            if (e.getJingle().getAction() == Jingle.Action.SESSION_ACCEPT || e.getJingle().getAction() == Jingle.Action.SESSION_TERMINATE) {
                jingleResponseFuture.complete(e.getJingle());
            }
        });
        jingleSession.initiate();
        try {
            Jingle jingle = (Jingle)jingleResponseFuture.get(timeout, TimeUnit.MILLISECONDS);
            if (jingle.getAction() == Jingle.Action.SESSION_TERMINATE) {
                throw new FileTransferRejectedException();
            }
            if (jingle.getAction() == Jingle.Action.SESSION_ACCEPT) {
                InBandByteStreamManager inBandByteStreamManager = (InBandByteStreamManager)this.xmppSession.getManager(InBandByteStreamManager.class);
                inBandByteStreamManager.initiateSession(responder, sessionId, 4096);
            }
            return new JingleFileTransferSession(jingleSession);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new XmppException((Throwable)e2);
        }
        catch (ExecutionException e3) {
            throw new XmppException((Throwable)e3);
        }
        catch (TimeoutException e4) {
            throw new NoResponseException("The receiver did not respond in time.");
        }
    }
}

