/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.pubsub.PubSubNode;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.NodeType;
import rocks.xmpp.extensions.pubsub.model.PubSub;
import rocks.xmpp.extensions.pubsub.model.PubSubFeature;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class PubSubService {
    private static final Logger logger = Logger.getLogger(PubSubService.class.getName());
    private final Jid service;
    private final String name;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final XmppSession xmppSession;

    PubSubService(Jid service, String name, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager) {
        this.service = service;
        this.name = name;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.xmppSession = xmppSession;
    }

    public AsyncResult<Collection<PubSubFeature>> discoverFeatures() {
        return this.serviceDiscoveryManager.discoverInformation(this.service).thenApply(this::getFeatures);
    }

    Collection<PubSubFeature> getFeatures(InfoNode infoNode) {
        EnumSet<PubSubFeature> features = EnumSet.noneOf(PubSubFeature.class);
        infoNode.getFeatures().stream().filter(feature -> feature.startsWith("http://jabber.org/protocol/pubsub#")).forEach(feature -> {
            String f = feature.substring(feature.indexOf(35) + 1);
            try {
                PubSubFeature pubSubFeature = PubSubFeature.valueOf((String)f.toUpperCase().replace('-', '_'));
                if (pubSubFeature != null) {
                    features.add(pubSubFeature);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Server advertised unknown pubsub feature: {0}", f);
            }
        });
        return features;
    }

    public AsyncResult<List<PubSubNode>> discoverNodes() {
        return this.serviceDiscoveryManager.discoverItems(this.service).thenApply(itemNode -> itemNode.getItems().stream().map(item -> new PubSubNode(item.getNode(), this.service, this.xmppSession)).collect(Collectors.toList()));
    }

    public PubSubNode node(String node) {
        return new PubSubNode(node, NodeType.LEAF, this.service, this.xmppSession);
    }

    public AsyncResult<List<Subscription>> getSubscriptions() {
        return this.xmppSession.query(IQ.get((Jid)this.service, (Object)PubSub.withSubscriptions())).thenApply(result -> {
            PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
            return pubSub.getSubscriptions();
        });
    }

    public AsyncResult<List<Affiliation>> getAffiliations() {
        return this.xmppSession.query(IQ.get((Jid)this.service, (Object)PubSub.withAffiliations())).thenApply(result -> {
            PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
            return pubSub.getAffiliations();
        });
    }

    public AsyncResult<DataForm> getDefaultSubscriptionOptions() {
        return this.xmppSession.query(IQ.get((Jid)this.service, (Object)PubSub.withDefault())).thenApply(result -> {
            PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
            return pubSub.getDefault().getDataForm();
        });
    }

    public AsyncResult<DataForm> getDefaultNodeConfiguration() {
        return this.xmppSession.query(IQ.get((Jid)this.service, (Object)PubSubOwner.withDefault())).thenApply(result -> {
            PubSubOwner pubSubOwner = (PubSubOwner)result.getExtension(PubSubOwner.class);
            return pubSubOwner.getConfigurationForm();
        });
    }

    public Jid getAddress() {
        return this.service;
    }

    public String toString() {
        return this.service.toString();
    }

    public String getName() {
        return this.name;
    }
}

