/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.bytestreams.ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.s5b.LocalSocks5Server;
import rocks.xmpp.extensions.bytestreams.s5b.S5bEvent;
import rocks.xmpp.extensions.bytestreams.s5b.S5bSession;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5Protocol;
import rocks.xmpp.extensions.bytestreams.s5b.model.Socks5ByteStream;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHost;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;
import rocks.xmpp.util.concurrent.CompletionStages;

public final class Socks5ByteStreamManager
extends ByteStreamManager {
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final LocalSocks5Server localSocks5Server;
    private boolean localHostEnabled;
    private StreamHost streamHost;

    private Socks5ByteStreamManager(XmppSession xmppSession) {
        super(xmppSession);
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
        this.localSocks5Server = new LocalSocks5Server();
    }

    static S5bSession createS5bSession(Jid requester, Jid target, String sessionId, List<StreamHost> streamHosts, Duration timeout) throws IOException {
        Socket socketUsed = null;
        Jid streamHostUsed = null;
        IOException ioException = null;
        for (StreamHost streamHost : streamHosts) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(streamHost.getHostname(), streamHost.getPort()), (int)(timeout.toMillis() / (long)streamHosts.size()));
                Socks5Protocol.establishClientConnection(socket, Socks5ByteStream.hash((String)sessionId, (Jid)requester, (Jid)target), 0);
                socketUsed = socket;
                streamHostUsed = streamHost.getJid();
                break;
            }
            catch (IOException e) {
                ioException = e;
            }
        }
        if (streamHostUsed == null) {
            throw new IOException("Unable to connect to any stream host.", ioException);
        }
        return new S5bSession(sessionId, socketUsed, streamHostUsed, timeout);
    }

    protected void initialize() {
        super.initialize();
        this.xmppSession.addIQHandler(Socks5ByteStream.class, (IQHandler)new AbstractIQHandler(new IQ.Type[]{IQ.Type.SET}){

            protected IQ processRequest(IQ iq) {
                Socks5ByteStream socks5ByteStream = (Socks5ByteStream)iq.getExtension(Socks5ByteStream.class);
                if (socks5ByteStream.getSessionId() == null) {
                    return iq.createError(Condition.BAD_REQUEST);
                }
                XmppUtils.notifyEventListeners((Iterable)Socks5ByteStreamManager.this.byteStreamListeners, (EventObject)new S5bEvent((Object)Socks5ByteStreamManager.this, socks5ByteStream.getSessionId(), Socks5ByteStreamManager.this.xmppSession, iq, new ArrayList<StreamHost>(socks5ByteStream.getStreamHosts())));
                return null;
            }
        });
    }

    public synchronized boolean isLocalHostEnabled() {
        return this.localHostEnabled;
    }

    public synchronized void setLocalHostEnabled(boolean enabled) {
        this.localHostEnabled = enabled;
        if (!enabled) {
            this.localSocks5Server.stop();
        }
    }

    public int getPort() {
        return this.localSocks5Server.getPort();
    }

    public void setPort(int port) {
        this.localSocks5Server.setPort(port);
    }

    protected void onEnable() {
        super.onEnable();
        if (this.isLocalHostEnabled()) {
            this.localSocks5Server.start();
        }
    }

    protected void onDisable() {
        super.onDisable();
        if (!this.isLocalHostEnabled()) {
            this.localSocks5Server.stop();
        }
    }

    public AsyncResult<List<StreamHost>> discoverProxies() {
        return this.serviceDiscoveryManager.discoverServices(Identity.proxyByteStreams()).thenCompose(items -> {
            Collection stages = items.stream().map(service -> this.xmppSession.query(IQ.get((Jid)service.getJid(), (Object)new Socks5ByteStream())).thenApply(result -> {
                Socks5ByteStream socks5ByteStream = (Socks5ByteStream)result.getExtension(Socks5ByteStream.class);
                if (socks5ByteStream != null) {
                    return socks5ByteStream.getStreamHosts();
                }
                return Collections.emptyList();
            })).collect(Collectors.toList());
            return CompletionStages.allOf((Collection)stages);
        });
    }

    public AsyncResult<List<StreamHost>> getAvailableStreamHosts() {
        StreamHost host = this.getStreamHost();
        AsyncResult hosts = host != null ? new AsyncResult(CompletableFuture.completedFuture(Collections.singletonList(host))) : this.discoverProxies();
        return hosts.thenApply(streamHosts -> {
            try {
                ArrayList<StreamHost> result = new ArrayList<StreamHost>();
                if (this.isLocalHostEnabled()) {
                    Jid requester = this.xmppSession.getConnectedResource();
                    result.add(new StreamHost(requester, this.localSocks5Server.getAddress(), this.localSocks5Server.getPort()));
                }
                IOException ioException = null;
                for (StreamHost streamHost : streamHosts) {
                    try {
                        Socket socket = new Socket();
                        Throwable throwable = null;
                        try {
                            socket.connect(new InetSocketAddress(streamHost.getHostname(), streamHost.getPort()), 5000);
                            result.add(streamHost);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (throwable != null) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        ioException = e;
                    }
                }
                if (result.isEmpty()) {
                    XmppException xmppException = new XmppException("No stream hosts found.");
                    if (ioException != null) {
                        ioException.initCause(ioException);
                    }
                    throw xmppException;
                }
                return result;
            }
            catch (XmppException e) {
                throw new CompletionException(e);
            }
        });
    }

    public synchronized void setStreamHost(StreamHost streamHost) {
        this.streamHost = streamHost;
    }

    public synchronized StreamHost getStreamHost() {
        return this.streamHost;
    }

    public AsyncResult<ByteStreamSession> initiateSession(Jid target, String sessionId) {
        if (this.isLocalHostEnabled()) {
            this.localSocks5Server.start();
        }
        return this.getAvailableStreamHosts().thenCompose(streamHosts -> {
            Jid requester = this.xmppSession.getConnectedResource();
            String hash = Socks5ByteStream.hash((String)sessionId, (Jid)requester, (Jid)target);
            this.localSocks5Server.allowedAddresses.add(hash);
            return this.xmppSession.query(IQ.set((Jid)target, (Object)new Socks5ByteStream(sessionId, (Collection)streamHosts, hash))).whenComplete((a, e) -> this.localSocks5Server.allowedAddresses.remove(hash)).thenComposeAsync(result -> {
                Socket socket;
                StreamHost usedStreamHost;
                Socks5ByteStream socks5ByteStream = (Socks5ByteStream)result.getExtension(Socks5ByteStream.class);
                StreamHost streamHostUsed = null;
                for (StreamHost streamHost : streamHosts) {
                    if (socks5ByteStream.getStreamHostUsed() == null || !socks5ByteStream.getStreamHostUsed().equals(streamHost.getJid())) continue;
                    streamHostUsed = streamHost;
                    break;
                }
                if ((usedStreamHost = streamHostUsed) == null) {
                    throw new CompletionException(new XmppException("Target did not respond with a stream host."));
                }
                if (!usedStreamHost.getJid().equals(requester)) {
                    socket = new Socket();
                    try {
                        socket.connect(new InetSocketAddress(usedStreamHost.getHostname(), usedStreamHost.getPort()));
                        Socks5Protocol.establishClientConnection(socket, hash, 0);
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                    return this.xmppSession.query(IQ.set((Jid)usedStreamHost.getJid(), (Object)Socks5ByteStream.activate((String)sessionId, (Jid)target))).thenApply(aVoid -> {
                        try {
                            return new S5bSession(sessionId, socket, usedStreamHost.getJid(), this.xmppSession.getConfiguration().getDefaultResponseTimeout());
                        }
                        catch (SocketException e) {
                            throw new CompletionException(e);
                        }
                    });
                }
                socket = this.localSocks5Server.getSocket(hash);
                if (socket == null) {
                    throw new CompletionException(new IOException("Not connected to stream host"));
                }
                try {
                    return CompletableFuture.completedFuture(new S5bSession(sessionId, socket, usedStreamHost.getJid(), this.xmppSession.getConfiguration().getDefaultResponseTimeout()));
                }
                catch (SocketException e) {
                    throw new CompletionException(e);
                }
            });
        });
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.localSocks5Server.stop();
    }
}

