/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.filetransfer.FileTransferStatusEvent;
import rocks.xmpp.util.XmppUtils;

public final class FileTransfer {
    private final long length;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final Set<Consumer<FileTransferStatusEvent>> fileTransferStatusListeners = new CopyOnWriteArraySet<Consumer<FileTransferStatusEvent>>();
    private final ExecutorService executorService;
    private final String sessionId;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INITIAL);
    private volatile Exception exception;
    private volatile long bytesTransferred;

    public FileTransfer(XmppSession xmppSession, String sessionId, InputStream inputStream, OutputStream outputStream, long length) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.length = length;
        this.sessionId = sessionId;
        this.executorService = Executors.newSingleThreadExecutor(xmppSession.getConfiguration().getThreadFactory("File Transfer Thread"));
    }

    public final void addFileTransferStatusListener(Consumer<FileTransferStatusEvent> fileTransferStatusListener) {
        this.fileTransferStatusListeners.add(fileTransferStatusListener);
    }

    public final void removeFileTransferStatusListener(Consumer<FileTransferStatusEvent> fileTransferStatusListener) {
        this.fileTransferStatusListeners.remove(fileTransferStatusListener);
    }

    private void notifyFileTransferStatusListeners() {
        XmppUtils.notifyEventListeners(this.fileTransferStatusListeners, (EventObject)new FileTransferStatusEvent(this, this.status.get(), this.bytesTransferred));
    }

    public final Status getStatus() {
        return this.status.get();
    }

    private void updateStatus(Status status) {
        if (this.status.getAndSet(status) != status) {
            this.notifyFileTransferStatusListeners();
        }
    }

    private void updateStatusIf(Status expected, Status status) {
        if (this.status.compareAndSet(expected, status)) {
            this.notifyFileTransferStatusListeners();
        }
    }

    public final boolean isDone() {
        return EnumSet.of(Status.CANCELED, Status.COMPLETED, Status.FAILED, Status.REJECTED).contains((Object)this.status.get());
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    private void setBytesTransferred(long bytesTransferred) {
        if (this.bytesTransferred == bytesTransferred) {
            return;
        }
        this.bytesTransferred = bytesTransferred;
        this.notifyFileTransferStatusListeners();
    }

    private void addBytesTransferred(long bytesTransferredAdditionally) {
        this.setBytesTransferred(this.bytesTransferred + bytesTransferredAdditionally);
    }

    public final double getProgress() {
        if (this.length != 0L) {
            return (double)this.getBytesTransferred() / (double)this.length;
        }
        return -1.0;
    }

    public final Future<?> transfer() {
        return this.executorService.submit(() -> {
            byte[] buffer = new byte[8192];
            this.bytesTransferred = 0L;
            this.updateStatus(Status.IN_PROGRESS);
            try {
                int len;
                while ((len = this.inputStream.read(buffer)) > -1 && this.status.get() != Status.CANCELED) {
                    this.outputStream.write(buffer, 0, len);
                    this.addBytesTransferred(len);
                }
                if (this.bytesTransferred != this.length && this.status.get() != Status.CANCELED) {
                    this.updateStatus(Status.FAILED);
                }
            }
            catch (IOException e) {
                this.exception = e;
                this.updateStatus(Status.FAILED);
            }
            finally {
                try {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        this.exception = e;
                        this.updateStatus(Status.FAILED);
                    }
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        this.exception = e;
                        this.updateStatus(Status.FAILED);
                    }
                }
                finally {
                    this.updateStatusIf(Status.IN_PROGRESS, Status.COMPLETED);
                }
            }
        });
    }

    public void cancel() {
        this.updateStatus(Status.CANCELED);
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final Exception getException() {
        return this.exception;
    }

    public static enum Status {
        INITIAL,
        CANCELED,
        COMPLETED,
        FAILED,
        IN_PROGRESS,
        REJECTED;

    }
}

