/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.SendTask;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.muc.InvitationDeclineEvent;
import rocks.xmpp.extensions.muc.MultiUserChatManager;
import rocks.xmpp.extensions.muc.Occupant;
import rocks.xmpp.extensions.muc.OccupantEvent;
import rocks.xmpp.extensions.muc.RoomInformation;
import rocks.xmpp.extensions.muc.SubjectChangeEvent;
import rocks.xmpp.extensions.muc.conference.model.DirectInvitation;
import rocks.xmpp.extensions.muc.model.Actor;
import rocks.xmpp.extensions.muc.model.Affiliation;
import rocks.xmpp.extensions.muc.model.DiscussionHistory;
import rocks.xmpp.extensions.muc.model.Item;
import rocks.xmpp.extensions.muc.model.Muc;
import rocks.xmpp.extensions.muc.model.MucFeature;
import rocks.xmpp.extensions.muc.model.RequestVoice;
import rocks.xmpp.extensions.muc.model.Role;
import rocks.xmpp.extensions.muc.model.RoomConfiguration;
import rocks.xmpp.extensions.muc.model.RoomInfo;
import rocks.xmpp.extensions.muc.model.admin.MucAdmin;
import rocks.xmpp.extensions.muc.model.owner.MucOwner;
import rocks.xmpp.extensions.muc.model.user.Decline;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.muc.model.user.Status;
import rocks.xmpp.extensions.register.model.Registration;
import rocks.xmpp.im.chat.Chat;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ChatRoom
extends Chat
implements Comparable<ChatRoom> {
    private final Set<Consumer<InvitationDeclineEvent>> invitationDeclineListeners = new CopyOnWriteArraySet<Consumer<InvitationDeclineEvent>>();
    private final Set<Consumer<SubjectChangeEvent>> subjectChangeListeners = new CopyOnWriteArraySet<Consumer<SubjectChangeEvent>>();
    private final Set<Consumer<OccupantEvent>> occupantListeners = new CopyOnWriteArraySet<Consumer<OccupantEvent>>();
    private final Map<String, Occupant> occupantMap = new ConcurrentHashMap<String, Occupant>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final MultiUserChatManager multiUserChatManager;
    private final String name;
    private final Jid roomJid;
    private final XmppSession xmppSession;
    private final Consumer<MessageEvent> messageListener;
    private final Consumer<PresenceEvent> presenceListener;
    private String nick;
    private boolean entered;

    ChatRoom(Jid roomJid, String name, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager, MultiUserChatManager multiUserChatManager) {
        if (Objects.requireNonNull(roomJid).getLocal() == null) {
            throw new IllegalArgumentException("roomJid must have a local part.");
        }
        if (roomJid.getResource() != null) {
            throw new IllegalArgumentException("roomJid must not have a resource part: " + roomJid.getResource());
        }
        this.name = name;
        this.roomJid = roomJid;
        this.xmppSession = xmppSession;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.multiUserChatManager = multiUserChatManager;
        this.messageListener = e -> {
            Message message = e.getMessage();
            if (message.getFrom().asBareJid().equals(roomJid)) {
                if (message.getType() == Message.Type.GROUPCHAT) {
                    if (message.getSubject() != null && message.getBody() == null) {
                        XmppUtils.notifyEventListeners(this.subjectChangeListeners, (EventObject)new SubjectChangeEvent(this, message.getSubject(), message.getFrom().getResource(), message.hasExtension(DelayedDelivery.class), DelayedDelivery.sendDate((Stanza)message)));
                    } else {
                        XmppUtils.notifyEventListeners((Iterable)this.inboundMessageListeners, (EventObject)new MessageEvent((Object)this, message, true));
                    }
                } else {
                    Decline decline;
                    MucUser mucUser = (MucUser)message.getExtension(MucUser.class);
                    if (mucUser != null && (decline = mucUser.getDecline()) != null) {
                        XmppUtils.notifyEventListeners(this.invitationDeclineListeners, (EventObject)new InvitationDeclineEvent(this, roomJid, decline.getFrom(), decline.getReason()));
                    }
                }
            }
        };
        this.presenceListener = e -> {
            String nick;
            MucUser mucUser;
            Presence presence = e.getPresence();
            if (presence.getFrom() != null && presence.getFrom().asBareJid().equals(roomJid) && (mucUser = (MucUser)presence.getExtension(MucUser.class)) != null && (nick = presence.getFrom().getResource()) != null) {
                boolean isSelfPresence = this.isSelfPresence(presence, nick);
                Occupant occupant = new Occupant(presence, isSelfPresence);
                if (presence.isAvailable()) {
                    Occupant previousOccupant = this.occupantMap.put(nick, occupant);
                    OccupantEvent.Type type = previousOccupant == null && (isSelfPresence || this.hasEntered()) ? OccupantEvent.Type.ENTERED : OccupantEvent.Type.STATUS_CHANGED;
                    XmppUtils.notifyEventListeners(this.occupantListeners, (EventObject)new OccupantEvent(this, occupant, type, null, null, null));
                } else if (presence.getType() == Presence.Type.UNAVAILABLE) {
                    this.occupantMap.remove(nick);
                    OccupantEvent occupantEvent = null;
                    if (mucUser.getItem() != null) {
                        Actor actor = mucUser.getItem().getActor();
                        String reason = mucUser.getItem().getReason();
                        if (!mucUser.getStatusCodes().isEmpty()) {
                            if (mucUser.getStatusCodes().contains(Status.KICKED)) {
                                occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.KICKED, actor, reason, null);
                            } else if (mucUser.getStatusCodes().contains(Status.BANNED)) {
                                occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.BANNED, actor, reason, null);
                            } else if (mucUser.getStatusCodes().contains(Status.MEMBERSHIP_REVOKED)) {
                                occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.MEMBERSHIP_REVOKED, actor, reason, null);
                            } else if (mucUser.getStatusCodes().contains(Status.NICK_CHANGED)) {
                                occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.NICKNAME_CHANGED, actor, reason, null);
                            } else if (mucUser.getStatusCodes().contains(Status.SERVICE_SHUT_DOWN)) {
                                occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.SYSTEM_SHUTDOWN, actor, reason, null);
                            }
                        } else {
                            occupantEvent = mucUser.getDestroy() != null ? new OccupantEvent(this, occupant, OccupantEvent.Type.ROOM_DESTROYED, actor, mucUser.getDestroy().getReason(), mucUser.getDestroy().getJid()) : new OccupantEvent(this, occupant, OccupantEvent.Type.EXITED, null, null, null);
                        }
                    } else {
                        occupantEvent = new OccupantEvent(this, occupant, OccupantEvent.Type.EXITED, null, null, null);
                    }
                    if (occupantEvent != null) {
                        XmppUtils.notifyEventListeners(this.occupantListeners, (EventObject)occupantEvent);
                    }
                    if (isSelfPresence) {
                        this.userHasExited();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userHasExited() {
        this.xmppSession.removeInboundMessageListener(this.messageListener);
        this.xmppSession.removeInboundPresenceListener(this.presenceListener);
        ChatRoom chatRoom = this;
        synchronized (chatRoom) {
            this.entered = false;
            this.nick = null;
        }
        this.multiUserChatManager.roomExited(this);
        this.occupantMap.clear();
    }

    private synchronized boolean isSelfPresence(Presence presence, String currentNick) {
        boolean isSelfPresence = false;
        MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
        if (mucUser != null) {
            boolean nicknameChanged = mucUser.getStatusCodes().contains(Status.SERVICE_HAS_ASSIGNED_OR_MODIFIED_NICK);
            if (nicknameChanged) {
                this.nick = presence.getFrom().getResource();
            }
            isSelfPresence = mucUser.getStatusCodes().contains(Status.SELF_PRESENCE) || nicknameChanged;
        }
        String usedNick = this.nick != null ? this.nick : currentNick;
        return isSelfPresence || usedNick != null && presence.getFrom() != null && usedNick.equals(presence.getFrom().getResource());
    }

    public void addInvitationDeclineListener(Consumer<InvitationDeclineEvent> invitationDeclineListener) {
        this.invitationDeclineListeners.add(invitationDeclineListener);
    }

    public void removeInvitationDeclineListener(Consumer<InvitationDeclineEvent> invitationDeclineListener) {
        this.invitationDeclineListeners.remove(invitationDeclineListener);
    }

    public void addSubjectChangeListener(Consumer<SubjectChangeEvent> subjectChangeListener) {
        this.subjectChangeListeners.add(subjectChangeListener);
    }

    public void removeSubjectChangeListener(Consumer<SubjectChangeEvent> subjectChangeListener) {
        this.subjectChangeListeners.remove(subjectChangeListener);
    }

    public void addOccupantListener(Consumer<OccupantEvent> occupantListener) {
        this.occupantListeners.add(occupantListener);
    }

    public void removeOccupantListener(Consumer<OccupantEvent> occupantListener) {
        this.occupantListeners.remove(occupantListener);
    }

    public AsyncResult<Presence> enter(String nick) {
        return this.enter(nick, null, null);
    }

    public AsyncResult<Presence> enter(String nick, String password) {
        return this.enter(nick, password, null);
    }

    public AsyncResult<Presence> enter(String nick, DiscussionHistory history) {
        return this.enter(nick, null, history);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AsyncResult<Presence> enter(String nick, String password, DiscussionHistory history) {
        Objects.requireNonNull(nick, "nick must not be null.");
        ChatRoom chatRoom = this;
        synchronized (chatRoom) {
            if (this.entered) {
                throw new IllegalStateException("You already entered this room.");
            }
            this.nick = nick;
        }
        this.xmppSession.addInboundMessageListener(this.messageListener);
        this.xmppSession.addInboundPresenceListener(this.presenceListener);
        Presence enterPresence = new Presence(this.roomJid.withResource((CharSequence)nick));
        enterPresence.getExtensions().add(Muc.withPasswordAndHistory((String)password, (DiscussionHistory)history));
        return this.xmppSession.sendAndAwaitPresence(enterPresence, presence -> {
            Jid room = presence.getFrom().asBareJid();
            return room.equals(this.roomJid) && this.isSelfPresence((Presence)presence, nick);
        }).whenComplete((presence, e) -> {
            if (e != null) {
                this.userHasExited();
            } else {
                this.multiUserChatManager.roomEntered(this, nick);
                ChatRoom chatRoom = this;
                synchronized (chatRoom) {
                    this.entered = true;
                }
            }
        });
    }

    public AsyncResult<Message> changeSubject(String subject) {
        Message message = new Message(this.roomJid, Message.Type.GROUPCHAT, null, subject, null);
        return this.xmppSession.sendAndAwaitMessage(message, message1 -> message1.getBody() == null && message1.getSubject() != null && message1.getSubject().equals(subject));
    }

    public SendTask<Message> sendMessage(String message) {
        Message m = new Message(this.roomJid, Message.Type.GROUPCHAT, message);
        return this.xmppSession.sendMessage(m);
    }

    public SendTask<Message> sendMessage(Message message) {
        Message m = new Message(this.roomJid, Message.Type.GROUPCHAT, (Collection)message.getBodies(), (Collection)message.getSubjects(), message.getThread(), message.getParentThread(), message.getId(), message.getFrom(), message.getLanguage(), (Collection)message.getExtensions(), message.getError());
        return this.xmppSession.sendMessage(m);
    }

    public final AsyncResult<Presence> changeNickname(String newNickname) {
        if (!this.hasEntered()) {
            throw new IllegalStateException("You must have entered the room to change your nickname.");
        }
        Presence changeNickNamePresence = new Presence(this.roomJid.withResource((CharSequence)newNickname));
        return this.xmppSession.sendAndAwaitPresence(changeNickNamePresence, presence -> presence.getFrom().equals(changeNickNamePresence.getTo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAvailabilityStatus(Presence.Show show, String status) {
        Presence presence;
        ChatRoom chatRoom = this;
        synchronized (chatRoom) {
            if (!this.entered) {
                throw new IllegalStateException("You must have entered the room to change the availability status.");
            }
            presence = new Presence(this.roomJid.withResource((CharSequence)this.nick), show, status);
        }
        this.xmppSession.send((StreamElement)presence);
    }

    public void invite(Jid invitee, String reason) {
        this.invite(invitee, reason, false);
    }

    public void invite(Jid invitee, String reason, boolean direct) {
        Message message;
        if (direct) {
            message = new Message(invitee, Message.Type.NORMAL);
            message.addExtension((Object)new DirectInvitation(this.roomJid, null, reason));
        } else {
            message = new Message(this.roomJid, Message.Type.NORMAL);
            message.addExtension((Object)MucUser.withInvites((Invite[])new Invite[]{new Invite(invitee, reason)}));
        }
        this.xmppSession.send((StreamElement)message);
    }

    public AsyncResult<DataForm> getRegistrationForm() {
        return this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)Registration.empty())).thenApply(result -> {
            Registration registration = (Registration)result.getExtension(Registration.class);
            if (registration != null) {
                return registration.getRegistrationForm();
            }
            return null;
        });
    }

    public AsyncResult<IQ> register(Registration registration) {
        Objects.requireNonNull(registration, "registration must not be null.");
        if (registration.getRegistrationForm() != null) {
            if (registration.getRegistrationForm().getType() != DataForm.Type.SUBMIT) {
                throw new IllegalArgumentException("Data Form must be of type 'submit'");
            }
            if (!"http://jabber.org/protocol/muc#register".equals(registration.getRegistrationForm().getFormType())) {
                throw new IllegalArgumentException("Data Form is not of type 'http://jabber.org/protocol/muc#register'");
            }
        }
        return this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)registration));
    }

    public AsyncResult<String> discoverReservedNickname() {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getManager(ServiceDiscoveryManager.class);
        return serviceDiscoveryManager.discoverInformation(this.roomJid, "x-roomuser-item").thenApply(infoNode -> {
            if (infoNode != null) {
                for (Identity identity : infoNode.getIdentities()) {
                    if (!"conference".equals(identity.getCategory()) || !"text".equals(identity.getType())) continue;
                    return identity.getName();
                }
            }
            return null;
        });
    }

    public void requestVoice() {
        Message message = new Message(this.roomJid);
        RequestVoice requestVoice = RequestVoice.builder().role(Role.PARTICIPANT).build();
        message.addExtension((Object)requestVoice.getDataForm());
        this.xmppSession.send((StreamElement)message);
    }

    public AsyncResult<Void> exit() {
        return this.exit(null);
    }

    public final AsyncResult<Void> exit(String message) {
        if (!this.hasEntered()) {
            return new AsyncResult(CompletableFuture.completedFuture(null));
        }
        String usedNick = this.getNick();
        return this.xmppSession.sendAndAwaitPresence(new Presence(this.roomJid.withResource((CharSequence)usedNick), Presence.Type.UNAVAILABLE, message), presence -> {
            Jid room = presence.getFrom().asBareJid();
            return !presence.isAvailable() && room.equals(this.roomJid) && this.isSelfPresence((Presence)presence, usedNick);
        }).handle((result, throwable) -> {
            this.userHasExited();
            return null;
        });
    }

    public final synchronized boolean hasEntered() {
        return this.entered;
    }

    public AsyncResult<List<Item>> getVoiceList() {
        return this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucAdmin.withItem((Role)Role.PARTICIPANT, null, null))).thenApply(result -> {
            MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
            return mucAdmin.getItems();
        });
    }

    public AsyncResult<IQ> changeAffiliationsOrRoles(List<Item> items) {
        return this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)MucAdmin.withItems(items)));
    }

    public AsyncResult<List<Item>> getBanList() {
        return this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucAdmin.withItem((Affiliation)Affiliation.OUTCAST, null, null))).thenApply(result -> {
            MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
            return mucAdmin.getItems();
        });
    }

    public final AsyncResult<IQ> changeAffiliation(Affiliation affiliation, Jid user, String reason) {
        return this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)MucAdmin.withItem((Affiliation)affiliation, (Jid)user, null, (String)reason)));
    }

    private AsyncResult<IQ> changeAffiliation(Affiliation affiliation, Jid user, String nick, String reason) {
        return this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)MucAdmin.withItem((Affiliation)affiliation, (Jid)user, (String)nick, (String)reason)));
    }

    public final AsyncResult<IQ> banUser(Jid user, String reason) {
        return this.changeAffiliation(Affiliation.OUTCAST, user, reason);
    }

    public final AsyncResult<IQ> grantMembership(Jid user, String nick, String reason) {
        return this.changeAffiliation(Affiliation.MEMBER, user, nick, reason);
    }

    public final AsyncResult<IQ> revokeMembership(Jid user, String reason) {
        return this.changeAffiliation(Affiliation.NONE, user, reason);
    }

    public final AsyncResult<IQ> grantOwnerStatus(Jid user, String reason) {
        return this.changeAffiliation(Affiliation.OWNER, user, reason);
    }

    public final AsyncResult<IQ> revokeOwnerStatus(Jid user, String reason) {
        return this.changeAffiliation(Affiliation.ADMIN, user, reason);
    }

    public final AsyncResult<IQ> grantAdminStatus(Jid user, String reason) {
        return this.changeAffiliation(Affiliation.ADMIN, user, reason);
    }

    public final AsyncResult<IQ> revokeAdminStatus(Jid user, String reason) {
        return this.changeAffiliation(Affiliation.MEMBER, user, reason);
    }

    public final AsyncResult<IQ> changeRole(Role role, String nickname, String reason) {
        return this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)MucAdmin.withItem((Role)role, (String)nickname, (String)reason)));
    }

    public final AsyncResult<IQ> kickOccupant(String nickname, String reason) {
        return this.changeRole(Role.NONE, nickname, reason);
    }

    public final AsyncResult<IQ> grantVoice(String nickname, String reason) {
        return this.changeRole(Role.PARTICIPANT, nickname, reason);
    }

    public final AsyncResult<IQ> revokeVoice(String nickname, String reason) {
        return this.changeRole(Role.VISITOR, nickname, reason);
    }

    public final AsyncResult<IQ> grantModeratorStatus(String nickname, String reason) {
        return this.changeRole(Role.MODERATOR, nickname, reason);
    }

    public final AsyncResult<IQ> revokeModeratorStatus(String nickname, String reason) {
        return this.changeRole(Role.PARTICIPANT, nickname, reason);
    }

    public AsyncResult<List<Item>> getOwners() {
        return this.getByAffiliation(Affiliation.OWNER);
    }

    public AsyncResult<List<Item>> getOutcasts() {
        return this.getByAffiliation(Affiliation.OUTCAST);
    }

    public AsyncResult<List<Item>> getAdmins() {
        return this.getByAffiliation(Affiliation.ADMIN);
    }

    public AsyncResult<List<Item>> getMembers() {
        return this.getByAffiliation(Affiliation.MEMBER);
    }

    private AsyncResult<List<Item>> getByAffiliation(Affiliation affiliation) {
        return this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucAdmin.withItem((Affiliation)affiliation, null, null))).thenApply(result -> {
            MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
            return mucAdmin.getItems();
        });
    }

    public AsyncResult<List<Item>> getModerators() {
        return this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucAdmin.withItem((Role)Role.MODERATOR, null, null))).thenApply(result -> {
            MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
            return mucAdmin.getItems();
        });
    }

    public AsyncResult<RoomInformation> getRoomInformation() {
        return this.serviceDiscoveryManager.discoverInformation(this.roomJid).thenApply(infoNode -> {
            Identity identity = null;
            HashSet<MucFeature> mucFeatures = new HashSet<MucFeature>();
            RoomInfo roomInfo = null;
            if (infoNode != null) {
                Set identities = infoNode.getIdentities();
                Iterator iterator = identities.iterator();
                if (iterator.hasNext()) {
                    identity = (Identity)iterator.next();
                }
                for (String feature : infoNode.getFeatures()) {
                    for (MucFeature mucFeature : MucFeature.values()) {
                        if (!mucFeature.getServiceDiscoveryFeature().equals(feature)) continue;
                        mucFeatures.add(mucFeature);
                    }
                }
                for (DataForm dataForm : infoNode.getExtensions()) {
                    String formType = dataForm.getFormType();
                    if (!"http://jabber.org/protocol/muc#roominfo".equals(formType)) continue;
                    roomInfo = new RoomInfo(dataForm);
                    break;
                }
            }
            return new RoomInformation(identity, mucFeatures, roomInfo);
        });
    }

    public AsyncResult<List<String>> discoverOccupants() {
        return this.serviceDiscoveryManager.discoverItems(this.roomJid).thenApply(itemNode -> {
            ArrayList occupants = new ArrayList();
            List items = itemNode.getItems();
            items.stream().filter(item -> item.getJid() != null).forEach(item -> {
                String nickname = item.getJid().getResource();
                if (nickname != null) {
                    occupants.add(nickname);
                }
            });
            return occupants;
        });
    }

    public Collection<Occupant> getOccupants() {
        return this.occupantMap.values();
    }

    public Occupant getOccupant(String nickname) {
        return this.occupantMap.get(nickname);
    }

    public AsyncResult<DataForm> getConfigurationForm() {
        return this.xmppSession.query(IQ.get((Jid)this.roomJid, (Object)MucOwner.empty())).thenApply(result -> {
            MucOwner mucOwner = (MucOwner)result.getExtension(MucOwner.class);
            return mucOwner.getConfigurationForm();
        });
    }

    public AsyncResult<IQ> configure(RoomConfiguration roomConfiguration) {
        Objects.requireNonNull(roomConfiguration, "roomConfiguration must not be null.");
        MucOwner mucOwner = MucOwner.withConfiguration((DataForm)roomConfiguration.getDataForm());
        return this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)mucOwner));
    }

    public final String getName() {
        return this.name;
    }

    public final synchronized String getNick() {
        return this.nick;
    }

    public AsyncResult<IQ> destroy(String reason) {
        MucOwner mucOwner = MucOwner.withDestroy((Jid)this.roomJid, (String)reason);
        return this.xmppSession.query(IQ.set((Jid)this.roomJid, (Object)mucOwner));
    }

    public final AsyncResult<IQ> destroy() {
        return this.destroy(null);
    }

    public Jid getAddress() {
        return this.roomJid;
    }

    public AsyncResult<Set<String>> discoverAllowableTraffic() {
        return this.serviceDiscoveryManager.discoverInformation(this.roomJid, "http://jabber.org/protocol/muc#traffic").thenApply(InfoNode::getFeatures);
    }

    public String toString() {
        return this.roomJid.toString();
    }

    @Override
    public int compareTo(ChatRoom o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result;
            if (this.name != null) {
                result = o.name != null ? Collator.getInstance().compare(this.name, o.name) : -1;
            } else {
                int n = result = o.name != null ? 1 : 0;
            }
            if (result == 0) {
                return this.roomJid.compareTo((Object)o.roomJid);
            }
            return result;
        }
        return -1;
    }
}

