/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.muc.ChatRoom;
import rocks.xmpp.extensions.muc.ChatService;
import rocks.xmpp.extensions.muc.InvitationEvent;
import rocks.xmpp.extensions.muc.conference.model.DirectInvitation;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.rsm.ResultSetProvider;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class MultiUserChatManager
extends Manager {
    private static final String ROOMS_NODE = "http://jabber.org/protocol/muc#rooms";
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final Set<Consumer<InvitationEvent>> invitationListeners = new CopyOnWriteArraySet<Consumer<InvitationEvent>>();
    private final Map<Jid, Item> enteredRoomsMap = new ConcurrentSkipListMap<Jid, Item>();
    private final Consumer<MessageEvent> messageListener;
    private final ResultSetProvider<Item> itemProvider;

    private MultiUserChatManager(XmppSession xmppSession) {
        super(xmppSession, true);
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
        this.messageListener = e -> {
            Message message = e.getMessage();
            MucUser mucUser = (MucUser)message.getExtension(MucUser.class);
            if (mucUser != null) {
                for (Invite invite : mucUser.getInvites()) {
                    XmppUtils.notifyEventListeners(this.invitationListeners, (EventObject)new InvitationEvent((Object)this, xmppSession, invite.getFrom(), message.getFrom(), invite.getReason(), mucUser.getPassword(), invite.isContinue(), invite.getThread(), true));
                }
            } else {
                DirectInvitation directInvitation = (DirectInvitation)message.getExtension(DirectInvitation.class);
                if (directInvitation != null) {
                    XmppUtils.notifyEventListeners(this.invitationListeners, (EventObject)new InvitationEvent((Object)this, xmppSession, message.getFrom(), directInvitation.getRoomAddress(), directInvitation.getReason(), directInvitation.getPassword(), directInvitation.isContinue(), directInvitation.getThread(), false));
                }
            }
        };
        this.itemProvider = ResultSetProvider.forItems(this.enteredRoomsMap.values());
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addInboundMessageListener(this.messageListener);
        this.serviceDiscoveryManager.setItemProvider(ROOMS_NODE, this.itemProvider);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeInboundMessageListener(this.messageListener);
        this.serviceDiscoveryManager.setItemProvider(ROOMS_NODE, null);
    }

    public void addInvitationListener(Consumer<InvitationEvent> invitationListener) {
        this.invitationListeners.add(invitationListener);
    }

    public void removeInvitationListener(Consumer<InvitationEvent> invitationListener) {
        this.invitationListeners.remove(invitationListener);
    }

    public AsyncResult<List<ChatService>> discoverChatServices() {
        return this.serviceDiscoveryManager.discoverServices(Identity.conferenceText()).thenApply(services -> services.stream().map(service -> new ChatService(service.getJid(), service.getName(), this.xmppSession, this.serviceDiscoveryManager, this)).collect(Collectors.toList()));
    }

    public AsyncResult<List<Item>> discoverEnteredRooms(Jid contact) {
        return this.serviceDiscoveryManager.discoverItems(contact, ROOMS_NODE).thenApply(ItemNode::getItems);
    }

    public ChatService createChatService(Jid chatService) {
        return new ChatService(chatService, null, this.xmppSession, this.serviceDiscoveryManager, this);
    }

    public ChatRoom createChatRoom(Jid roomAddress) {
        return new ChatRoom(roomAddress, null, this.xmppSession, this.serviceDiscoveryManager, this);
    }

    void roomEntered(ChatRoom chatRoom, String nick) {
        this.enteredRoomsMap.put(chatRoom.getAddress(), new Item(chatRoom.getAddress(), null, nick));
    }

    void roomExited(ChatRoom chatRoom) {
        this.enteredRoomsMap.remove(chatRoom.getAddress());
    }

    protected void dispose() {
        this.invitationListeners.clear();
    }
}

