/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.last;

import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.idle.model.Idle;
import rocks.xmpp.extensions.last.model.LastActivity;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class LastActivityManager
extends Manager {
    private final Consumer<PresenceEvent> outboundPresenceListener;
    private final IQHandler iqHandler;
    private Supplier<Instant> idleStrategy;
    private Instant lastSentStanza = Instant.now();
    private final Consumer<MessageEvent> outboundMessageListener;

    private LastActivityManager(XmppSession xmppSession) {
        super(xmppSession);
        this.idleStrategy = this::getLastSentStanzaTime;
        this.outboundPresenceListener = e -> {
            Presence presence = e.getPresence();
            if (presence.getTo() == null) {
                LastActivityManager lastActivityManager = this;
                synchronized (lastActivityManager) {
                    if (this.idleStrategy != null && presence.isAvailable() && EnumSet.of(Presence.Show.AWAY, Presence.Show.XA).contains(presence.getShow())) {
                        Instant idleSince = this.idleStrategy.get();
                        if (idleSince != null) {
                            if (!presence.hasExtension(Idle.class)) {
                                presence.addExtension((Object)Idle.since((OffsetDateTime)OffsetDateTime.ofInstant(idleSince, ZoneOffset.UTC)));
                            }
                            if (!presence.hasExtension(LastActivity.class)) {
                                presence.addExtension((Object)new LastActivity(LastActivityManager.getSecondsSince(idleSince), presence.getStatus()));
                            }
                        }
                    } else {
                        this.lastSentStanza = Instant.now();
                    }
                }
            }
        };
        this.iqHandler = new AbstractIQHandler(new IQ.Type[]{IQ.Type.GET}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IQ processRequest(IQ iq) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    Instant idleSince;
                    Instant instant = idleSince = LastActivityManager.this.idleStrategy != null ? (Instant)LastActivityManager.this.idleStrategy.get() : null;
                    if (idleSince != null) {
                        return iq.createResult((Object)new LastActivity(LastActivityManager.getSecondsSince(idleSince), null));
                    }
                    return iq.createError(Condition.SERVICE_UNAVAILABLE);
                }
            }
        };
        this.outboundMessageListener = e -> {
            LastActivityManager lastActivityManager = this;
            synchronized (lastActivityManager) {
                this.lastSentStanza = Instant.now();
            }
        };
    }

    static long getSecondsSince(Instant date) {
        return Math.max(0L, Duration.between(date, Instant.now()).getSeconds());
    }

    public synchronized Instant getLastSentStanzaTime() {
        return this.lastSentStanza;
    }

    public synchronized void setIdleStrategy(Supplier<Instant> idleStrategy) {
        this.idleStrategy = idleStrategy;
    }

    public synchronized Supplier<Instant> getIdleStrategy() {
        return this.idleStrategy;
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addOutboundPresenceListener(this.outboundPresenceListener);
        this.xmppSession.addOutboundMessageListener(this.outboundMessageListener);
        this.xmppSession.addIQHandler(LastActivity.class, this.iqHandler);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeOutboundPresenceListener(this.outboundPresenceListener);
        this.xmppSession.removeOutboundMessageListener(this.outboundMessageListener);
        this.xmppSession.removeIQHandler(LastActivity.class);
    }

    public AsyncResult<LastActivity> getLastActivity(Jid jid) {
        return this.xmppSession.query(IQ.get((Jid)jid, (Object)new LastActivity()), LastActivity.class);
    }
}

