/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.util.List;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.pubsub.PubSubService;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class PubSubManager
extends Manager {
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    private PubSubManager(XmppSession xmppSession) {
        super(xmppSession);
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    public AsyncResult<List<PubSubService>> discoverPubSubServices() {
        return this.serviceDiscoveryManager.discoverServices(Identity.pubsubService()).thenApply(services -> services.stream().map(service -> new PubSubService(service.getJid(), service.getName(), this.xmppSession, this.serviceDiscoveryManager)).collect(Collectors.toList()));
    }

    public PubSubService createPubSubService(Jid service) {
        return new PubSubService(service, null, this.xmppSession, this.serviceDiscoveryManager);
    }

    public PubSubService createPersonalEventingService() {
        return new PubSubService(this.xmppSession.getConnectedResource().asBareJid(), "Personal Eventing Service", this.xmppSession, this.serviceDiscoveryManager);
    }
}

