/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rtt;

import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.rtt.RealTimeMessage;
import rocks.xmpp.extensions.rtt.RealTimeTextChangeEvent;
import rocks.xmpp.extensions.rtt.model.RealTimeText;
import rocks.xmpp.util.XmppUtils;

public final class InboundRealTimeMessage
extends RealTimeMessage {
    private static final ExecutorService PROCESS_ACTIONS_EXECUTOR = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"Real-time Text Processing Thread"));
    private final StringBuilder sb;
    private final BlockingQueue<RealTimeText.Action> actions = new LinkedBlockingQueue<RealTimeText.Action>();
    private final Jid from;
    private final Set<Consumer<RealTimeTextChangeEvent>> textChangeListeners = new CopyOnWriteArraySet<Consumer<RealTimeTextChangeEvent>>();

    InboundRealTimeMessage(XmppSession xmppSession, Jid contact, int sequence, String id) {
        this.from = contact;
        this.sequence.set(sequence);
        this.sb = new StringBuilder();
        this.id = id;
        if (xmppSession != null) {
            PROCESS_ACTIONS_EXECUTOR.execute(() -> {
                try {
                    while (true) {
                        RealTimeText.Action action;
                        if ((action = this.actions.poll(700L, TimeUnit.MILLISECONDS)) == null) {
                            if (this.complete) return;
                        }
                        if (action == null) continue;
                        if (action instanceof RealTimeText.WaitInterval) {
                            Long ms = ((RealTimeText.WaitInterval)action).getMilliSeconds();
                            if (ms == null) continue;
                            if (ms == Integer.MIN_VALUE) {
                                return;
                            }
                            BlockingQueue<RealTimeText.Action> blockingQueue = this.actions;
                            synchronized (blockingQueue) {
                                this.actions.wait(ms);
                                continue;
                            }
                        }
                        this.applyActionElement(action);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processActions(Collection<RealTimeText.Action> actions, boolean incrementSequence) {
        if (this.isComplete()) {
            throw new IllegalStateException("Real-time message is already completed.");
        }
        if (incrementSequence) {
            this.sequence.getAndIncrement();
        }
        this.actions.addAll(actions);
        BlockingQueue<RealTimeText.Action> blockingQueue = this.actions;
        synchronized (blockingQueue) {
            this.actions.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyActionElement(RealTimeText.Action action) {
        String s;
        InboundRealTimeMessage inboundRealTimeMessage = this;
        synchronized (inboundRealTimeMessage) {
            if (action instanceof RealTimeText.InsertText) {
                RealTimeText.InsertText insertText = (RealTimeText.InsertText)action;
                if (insertText.getText() != null) {
                    int charCount = 0;
                    int pos = this.normalizePosition(insertText.getPosition());
                    for (int i = 0; i < this.sb.codePointCount(0, this.sb.length()) && i < pos; ++i) {
                        charCount += Character.charCount(this.sb.codePointAt(charCount));
                    }
                    this.sb.insert(charCount, insertText.getText());
                }
            } else if (action instanceof RealTimeText.EraseText) {
                RealTimeText.EraseText eraseText = (RealTimeText.EraseText)action;
                Integer n = eraseText.getNumberOfCharacters();
                if (n == null) {
                    n = 1;
                }
                if (n < 0) {
                    n = 0;
                }
                int i = 0;
                int endIndex = 0;
                int startIndex = 0;
                int pos = this.normalizePosition(eraseText.getPosition());
                while (i < this.sb.codePointCount(0, this.sb.length()) && i < pos) {
                    if (i++ < pos - n) {
                        startIndex += Character.charCount(this.sb.codePointAt(startIndex));
                    }
                    endIndex += Character.charCount(this.sb.codePointAt(endIndex));
                }
                if (startIndex <= endIndex && startIndex <= this.sb.length()) {
                    this.sb.delete(startIndex, endIndex);
                }
            }
            s = this.sb.toString();
        }
        XmppUtils.notifyEventListeners(this.textChangeListeners, (EventObject)new RealTimeTextChangeEvent(this, s));
    }

    private int normalizePosition(Integer pos) {
        if (pos == null) {
            pos = this.sb.length();
        }
        if (pos < 0) {
            pos = 0;
        }
        if (pos > this.sb.length()) {
            pos = this.sb.length();
        }
        return pos;
    }

    synchronized void reset(int sequence, String id) {
        this.sequence.set(sequence);
        this.sb.setLength(0);
        this.id = id;
        this.actions.clear();
    }

    synchronized void complete() {
        if (!this.complete) {
            this.complete = true;
            this.actions.offer((RealTimeText.Action)new RealTimeText.WaitInterval(Integer.MIN_VALUE));
            this.textChangeListeners.clear();
        }
    }

    @Override
    public final synchronized String getText() {
        return this.sb.toString();
    }

    public final Jid getFrom() {
        return this.from;
    }

    public final void addRealTimeTextChangeListener(Consumer<RealTimeTextChangeEvent> realTimeTextListener) {
        this.textChangeListeners.add(realTimeTextListener);
    }

    public final void removeRealTimeTextChangeListener(Consumer<RealTimeTextChangeEvent> realTimeTextListener) {
        this.textChangeListeners.remove(realTimeTextListener);
    }
}

