/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.time;

import java.time.OffsetDateTime;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.time.handler.EntityTimeHandler;
import rocks.xmpp.extensions.time.model.EntityTime;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class EntityTimeManager
extends Manager {
    private final IQHandler iqHandler = new EntityTimeHandler();

    private EntityTimeManager(XmppSession xmppSession) {
        super(xmppSession);
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(EntityTime.class, this.iqHandler);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(EntityTime.class);
    }

    public AsyncResult<OffsetDateTime> getEntityTime(Jid jid) {
        AsyncResult query = this.xmppSession.query(IQ.get((Jid)jid, (Object)new EntityTime()));
        return query.thenApply(result -> {
            EntityTime entityTime = (EntityTime)result.getExtension(EntityTime.class);
            return entityTime != null ? entityTime.getDateTime() : null;
        });
    }
}

