/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpauth;

import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.httpauth.HttpAuthenticationEvent;
import rocks.xmpp.extensions.httpauth.model.ConfirmationRequest;
import rocks.xmpp.util.XmppUtils;

public final class HttpAuthenticationManager
extends Manager {
    private final Set<Consumer<HttpAuthenticationEvent>> httpAuthenticationListeners = new CopyOnWriteArraySet<Consumer<HttpAuthenticationEvent>>();
    private final IQHandler iqHandler;
    private final Consumer<MessageEvent> inboundMessageListener;

    private HttpAuthenticationManager(final XmppSession xmppSession) {
        super(xmppSession, true);
        this.iqHandler = new AbstractIQHandler(new IQ.Type[]{IQ.Type.GET}){

            protected IQ processRequest(IQ iq) {
                ConfirmationRequest confirmationRequest = (ConfirmationRequest)iq.getExtension(ConfirmationRequest.class);
                XmppUtils.notifyEventListeners((Iterable)HttpAuthenticationManager.this.httpAuthenticationListeners, (EventObject)new HttpAuthenticationEvent((Object)HttpAuthenticationManager.this, xmppSession, (Stanza)iq, confirmationRequest));
                return HttpAuthenticationManager.this.httpAuthenticationListeners.isEmpty() ? iq.createError(Condition.SERVICE_UNAVAILABLE) : null;
            }
        };
        this.inboundMessageListener = e -> {
            ConfirmationRequest confirmationRequest;
            Message message = e.getMessage();
            if ((message.getType() == null || message.getType() == Message.Type.NORMAL) && (confirmationRequest = (ConfirmationRequest)message.getExtension(ConfirmationRequest.class)) != null) {
                XmppUtils.notifyEventListeners(this.httpAuthenticationListeners, (EventObject)new HttpAuthenticationEvent((Object)this, xmppSession, (Stanza)message, confirmationRequest));
            }
        };
    }

    protected void onEnable() {
        super.onEnable();
        this.xmppSession.addIQHandler(ConfirmationRequest.class, this.iqHandler);
        this.xmppSession.addInboundMessageListener(this.inboundMessageListener);
    }

    protected void onDisable() {
        super.onDisable();
        this.xmppSession.removeIQHandler(ConfirmationRequest.class);
        this.xmppSession.removeInboundMessageListener(this.inboundMessageListener);
    }

    public void addHttpAuthenticationListener(Consumer<HttpAuthenticationEvent> httpAuthenticationListener) {
        this.httpAuthenticationListeners.add(httpAuthenticationListener);
    }

    public void removeHttpAuthenticationListener(Consumer<HttpAuthenticationEvent> httpAuthenticationListener) {
        this.httpAuthenticationListeners.remove(httpAuthenticationListener);
    }

    protected void dispose() {
        this.httpAuthenticationListeners.clear();
    }
}

