/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.transports.s5b;

import java.util.ArrayList;
import java.util.UUID;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.s5b.model.Socks5ByteStream;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHost;
import rocks.xmpp.extensions.jingle.JingleSession;
import rocks.xmpp.extensions.jingle.transports.TransportNegotiator;
import rocks.xmpp.extensions.jingle.transports.s5b.model.S5bTransportMethod;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class S5bTransportNegotiator
extends TransportNegotiator<S5bTransportMethod> {
    private final Socks5ByteStreamManager socks5ByteStreamManager;
    private final XmppSession xmppSession;

    protected S5bTransportNegotiator(JingleSession jingleSession, XmppSession xmppSession) {
        super(jingleSession);
        this.xmppSession = xmppSession;
        this.socks5ByteStreamManager = (Socks5ByteStreamManager)xmppSession.getManager(Socks5ByteStreamManager.class);
    }

    private AsyncResult<S5bTransportMethod> createTransport(Jid requester, Jid target) {
        return this.socks5ByteStreamManager.getAvailableStreamHosts().thenApply(streamHosts -> {
            String sessionId = UUID.randomUUID().toString();
            String hash = Socks5ByteStream.hash((String)sessionId, (Jid)requester, (Jid)target);
            ArrayList<S5bTransportMethod.Candidate> candidateList = new ArrayList<S5bTransportMethod.Candidate>();
            int localPriority = 0;
            for (StreamHost streamHost : streamHosts) {
                S5bTransportMethod.Candidate.Type type = streamHost.getJid().equals(this.xmppSession.getConnectedResource()) ? S5bTransportMethod.Candidate.Type.DIRECT : S5bTransportMethod.Candidate.Type.PROXY;
                candidateList.add(new S5bTransportMethod.Candidate(UUID.randomUUID().toString(), streamHost.getHostname(), streamHost.getPort(), streamHost.getJid(), type, S5bTransportMethod.calculatePriority((S5bTransportMethod.Candidate.Type)type, (int)localPriority++)));
            }
            return new S5bTransportMethod(sessionId, hash, Socks5ByteStream.Mode.TCP, candidateList);
        });
    }
}

