/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.avatar.AvatarChangeEvent;
import rocks.xmpp.extensions.avatar.AvatarManager;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.cache.DirectoryCache;
import rocks.xmpp.util.concurrent.AsyncResult;

public abstract class AbstractAvatarManager
implements AvatarManager {
    private static final System.Logger logger = System.getLogger(AbstractAvatarManager.class.getName());
    protected final Set<Consumer<AvatarChangeEvent>> avatarChangeListeners = new CopyOnWriteArraySet<Consumer<AvatarChangeEvent>>();
    protected final XmppSession xmppSession;
    private final Map<String, byte[]> avatarCache;

    protected AbstractAvatarManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.avatarCache = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("avatars")) : null;
    }

    static BufferedImage asBufferedImage(byte[] bitmap) throws ConversionException {
        BufferedImage bufferedImage;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Objects.requireNonNull(bitmap));
        try {
            bufferedImage = Optional.ofNullable(ImageIO.read(inputStream)).orElseThrow(ConversionException::new);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConversionException(e);
            }
        }
        inputStream.close();
        return bufferedImage;
    }

    private static byte[] asPNG(BufferedImage bufferedImage) throws ConversionException {
        byte[] byArray;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (!ImageIO.write((RenderedImage)Objects.requireNonNull(bufferedImage), "png", outputStream)) {
                throw new ConversionException();
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConversionException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    protected void notifyListeners(Jid contact, byte[] avatar) {
        XmppUtils.notifyEventListeners(this.avatarChangeListeners, (EventObject)new AvatarChangeEvent(this, contact, avatar));
    }

    public final byte[] loadFromCache(String hash) {
        if (this.avatarCache != null) {
            try {
                return this.avatarCache.get(hash + ".avatar");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.WARNING, "Could not read avatar from cache.", (Throwable)e);
            }
        }
        return null;
    }

    public final void storeToCache(String hash, byte[] image) {
        if (this.avatarCache != null) {
            try {
                this.avatarCache.put(hash + ".avatar", image);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.WARNING, "Could not write avatar to cache.", (Throwable)e);
            }
        }
    }

    @Override
    public final AsyncResult<BufferedImage> getAvatarImage(Jid contact) {
        return this.getAvatar(Objects.requireNonNull(contact)).thenApply(bitmap -> {
            try {
                return bitmap == null ? null : AbstractAvatarManager.asBufferedImage(bitmap);
            }
            catch (ConversionException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public final AsyncResult<Void> publishAvatarImage(BufferedImage bufferedImage) throws XmppException {
        try {
            return this.publishAvatar(bufferedImage == null ? null : AbstractAvatarManager.asPNG(bufferedImage));
        }
        catch (ConversionException e) {
            throw new XmppException((Throwable)e);
        }
    }

    @Override
    public void addAvatarChangeListener(Consumer<AvatarChangeEvent> avatarChangeListener) {
        this.avatarChangeListeners.add(avatarChangeListener);
    }

    @Override
    public void removeAvatarChangeListener(Consumer<AvatarChangeEvent> avatarChangeListener) {
        this.avatarChangeListeners.remove(avatarChangeListener);
    }

    static final class ConversionException
    extends Exception {
        ConversionException() {
        }

        ConversionException(Throwable cause) {
            super(cause);
        }
    }
}

