/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.filetransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.xml.bind.DatatypeConverter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaErrorException;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.extensions.filetransfer.FileTransfer;
import rocks.xmpp.extensions.filetransfer.FileTransferNegotiator;
import rocks.xmpp.extensions.filetransfer.FileTransferOfferEvent;
import rocks.xmpp.extensions.filetransfer.FileTransferRejectedException;
import rocks.xmpp.extensions.filetransfer.model.FileTransferOffer;
import rocks.xmpp.extensions.oob.model.iq.OobIQ;
import rocks.xmpp.extensions.si.StreamInitiationManager;
import rocks.xmpp.extensions.si.profile.filetransfer.model.SIFileTransferOffer;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class FileTransferManager
extends Manager {
    private static final ExecutorService FILE_TRANSFER_OFFER_EXECUTOR = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"File Transfer Offer Thread"));
    private final StreamInitiationManager streamInitiationManager;
    private final EntityCapabilitiesManager entityCapabilitiesManager;
    private final Set<Consumer<FileTransferOfferEvent>> fileTransferOfferListeners = new CopyOnWriteArraySet<Consumer<FileTransferOfferEvent>>();

    private FileTransferManager(XmppSession xmppSession) {
        super(xmppSession, true);
        this.streamInitiationManager = (StreamInitiationManager)xmppSession.getManager(StreamInitiationManager.class);
        this.entityCapabilitiesManager = (EntityCapabilitiesManager)xmppSession.getManager(EntityCapabilitiesManager.class);
    }

    public static String md5Hash(Path source) throws IOException {
        String string;
        block9: {
            InputStream is = Files.newInputStream(source, new OpenOption[0]);
            try {
                int n;
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[8192];
                while ((n = is.read(buffer)) > -1) {
                    md.update(buffer, 0, n);
                }
                byte[] digest = md.digest();
                string = DatatypeConverter.printHexBinary((byte[])digest).toLowerCase();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AssertionError((Object)e);
                }
            }
            is.close();
        }
        return string;
    }

    public final AsyncResult<IQ> offerFile(URI uri, String description, Jid recipient, Duration timeout) {
        return this.xmppSession.query(IQ.set((Jid)recipient, (Object)new OobIQ(uri, description)), timeout).handle((iq, e) -> {
            if (e != null) {
                if (e instanceof CompletionException) {
                    if (e.getCause() instanceof StanzaErrorException && ((StanzaErrorException)e.getCause()).getCondition() == Condition.NOT_ACCEPTABLE) {
                        throw new CompletionException((Throwable)((Object)new FileTransferRejectedException()));
                    }
                    throw (CompletionException)e;
                }
                throw new CompletionException((Throwable)e);
            }
            return null;
        });
    }

    public final AsyncResult<FileTransfer> offerFile(File file, String description, Jid recipient, Duration timeout) throws IOException {
        return this.offerFile(Objects.requireNonNull(file, "file must not be null.").toPath(), description, recipient, timeout);
    }

    public final AsyncResult<FileTransfer> offerFile(Path source, String description, Jid recipient, Duration timeout) throws IOException {
        return this.offerFile(source, description, recipient, timeout, null, false);
    }

    public final AsyncResult<FileTransfer> offerFile(Path source, String description, Jid recipient, Duration timeout, String mimeType, boolean calculateHash) throws IOException {
        if (Files.notExists(Objects.requireNonNull(source, "source must not be null."), new LinkOption[0])) {
            throw new NoSuchFileException(source.getFileName().toString());
        }
        String hash = null;
        if (calculateHash) {
            hash = FileTransferManager.md5Hash(source);
        }
        return this.offerFile(Files.newInputStream(source, new OpenOption[0]), source.getFileName().toString(), Files.size(source), Files.getLastModifiedTime(source, new LinkOption[0]).toInstant(), description, recipient, timeout, UUID.randomUUID().toString(), mimeType, hash);
    }

    public final AsyncResult<FileTransfer> offerFile(InputStream source, String fileName, long fileSize, Instant lastModified, String description, Jid recipient, Duration timeout) {
        return this.offerFile(source, fileName, fileSize, lastModified, description, recipient, timeout, UUID.randomUUID().toString());
    }

    public final AsyncResult<FileTransfer> offerFile(InputStream source, String fileName, long fileSize, Instant lastModified, String description, Jid recipient, Duration timeout, String sessionId) {
        return this.offerFile(source, fileName, fileSize, lastModified, description, recipient, timeout, sessionId, null, null);
    }

    public final AsyncResult<FileTransfer> offerFile(InputStream source, String fileName, long fileSize, Instant lastModified, String description, Jid recipient, Duration timeout, String sessionId, String mimeType, String hash) {
        if (!Objects.requireNonNull(recipient, "jid must not be null.").isFullJid()) {
            throw new IllegalArgumentException("recipient must be a full JID (including resource)");
        }
        return this.entityCapabilitiesManager.isSupported("http://jabber.org/protocol/si", recipient).thenCompose(isSISupported -> {
            if (!isSISupported.booleanValue()) {
                throw new CompletionException(new XmppException("Feature not supported"));
            }
            return this.entityCapabilitiesManager.isSupported("http://jabber.org/protocol/si/profile/file-transfer", recipient).thenCompose(isSIFileTransferSupported -> {
                if (!isSIFileTransferSupported.booleanValue()) {
                    throw new CompletionException(new XmppException("Feature not supported"));
                }
                SIFileTransferOffer fileTransfer = new SIFileTransferOffer(fileName, fileSize, lastModified, hash, description, null);
                String mType = mimeType;
                if (mType == null) {
                    try {
                        mType = URLConnection.guessContentTypeFromStream(source);
                    }
                    catch (IOException e2) {
                        mType = null;
                    }
                }
                return this.streamInitiationManager.initiateStream(recipient, fileTransfer, mType, timeout, sessionId).handle((byteStreamSession, e) -> {
                    OutputStream outputStream;
                    if (e != null) {
                        if (e instanceof CompletionException) {
                            if (e.getCause() instanceof StanzaErrorException && ((StanzaErrorException)e.getCause()).getCondition() == Condition.FORBIDDEN) {
                                throw new CompletionException((Throwable)((Object)new FileTransferRejectedException()));
                            }
                            throw (CompletionException)e;
                        }
                        throw new CompletionException((Throwable)e);
                    }
                    try {
                        outputStream = byteStreamSession.getOutputStream();
                    }
                    catch (IOException e1) {
                        throw new CompletionException(e1);
                    }
                    return new FileTransfer(byteStreamSession.getSessionId(), source, outputStream, fileSize);
                });
            });
        });
    }

    public void fileTransferOffered(IQ iq, String sessionId, String mimeType, FileTransferOffer fileTransferOffer, Object protocol, FileTransferNegotiator fileTransferNegotiator) {
        FILE_TRANSFER_OFFER_EXECUTOR.execute(() -> XmppUtils.notifyEventListeners(this.fileTransferOfferListeners, (EventObject)new FileTransferOfferEvent((Object)this, iq, sessionId, mimeType, fileTransferOffer, protocol, fileTransferNegotiator)));
    }

    public void addFileTransferOfferListener(Consumer<FileTransferOfferEvent> fileTransferOfferListener) {
        this.fileTransferOfferListeners.add(fileTransferOfferListener);
    }

    public void removeFileTransferOfferListener(Consumer<FileTransferOfferEvent> fileTransferOfferListener) {
        this.fileTransferOfferListeners.remove(fileTransferOfferListener);
    }

    protected void dispose() {
        this.fileTransferOfferListeners.clear();
    }
}

